/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.settings.DebuggerDataViewsConfigurable;
import com.intellij.debugger.settings.DebuggerLaunchingConfigurable;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.DebuggerSteppingConfigurable;
import com.intellij.debugger.settings.JavaHotSwapConfigurableUi;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.UserRenderersConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerSettings
extends XDebuggerSettings<Element> {
    protected JavaDebuggerSettings() {
        super("java");
    }

    @NotNull
    public Collection<? extends Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        switch (category) {
            case GENERAL: {
                return Collections.singletonList(SimpleConfigurable.create((String)"reference.idesettings.debugger.launching", (String)OptionsBundle.message((String)"options.java.display.name", (Object[])new Object[0]), DebuggerLaunchingConfigurable.class, DebuggerSettings::getInstance));
            }
            case DATA_VIEWS: {
                return JavaDebuggerSettings.createDataViewsConfigurable();
            }
            case STEPPING: {
                return Collections.singletonList(SimpleConfigurable.create((String)"reference.idesettings.debugger.stepping", (String)OptionsBundle.message((String)"options.java.display.name", (Object[])new Object[0]), DebuggerSteppingConfigurable.class, DebuggerSettings::getInstance));
            }
            case HOTSWAP: {
                return Collections.singletonList(SimpleConfigurable.create((String)"reference.idesettings.debugger.hotswap", (String)OptionsBundle.message((String)"options.java.display.name", (Object[])new Object[0]), JavaHotSwapConfigurableUi.class, DebuggerSettings::getInstance));
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<Configurable> createDataViewsConfigurable() {
        return Arrays.asList(new DebuggerDataViewsConfigurable(null), SimpleConfigurable.create((String)"reference.idesettings.debugger.typerenderers", (String)DebuggerBundle.message((String)"user.renderers.configurable.display.name", (Object[])new Object[0]), UserRenderersConfigurable.class, NodeRendererSettings::getInstance));
    }

    public void generalApplied(@NotNull DebuggerSettingsCategory category) {
        if (category == DebuggerSettingsCategory.DATA_VIEWS) {
            NodeRendererSettings.getInstance().fireRenderersChanged();
        }
    }

    @Nullable
    public Element getState() {
        return null;
    }

    public void loadState(Element state) {
    }
}

