/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.DebuggerExpressionTextField;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Function;
import com.intellij.util.ui.AbstractTableCellEditor;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class CompoundRendererConfigurable
extends JPanel {
    private CompoundReferenceRenderer myRenderer;
    private CompoundReferenceRenderer myOriginalRenderer;
    private Project myProject;
    private final ClassNameEditorWithBrowseButton myClassNameField;
    private final JRadioButton myRbDefaultLabel;
    private final JRadioButton myRbExpressionLabel;
    private final JBCheckBox myShowTypeCheckBox;
    private final JRadioButton myRbDefaultChildrenRenderer;
    private final JRadioButton myRbExpressionChildrenRenderer;
    private final JRadioButton myRbListChildrenRenderer;
    private final DebuggerExpressionTextField myLabelEditor;
    private final DebuggerExpressionTextField myChildrenEditor;
    private final DebuggerExpressionTextField myChildrenExpandedEditor;
    private DebuggerExpressionTextField myListChildrenEditor;
    private final JLabel myExpandedLabel;
    private JBTable myTable;
    @NonNls
    private static final String EMPTY_PANEL_ID = "EMPTY";
    @NonNls
    private static final String DATA_PANEL_ID = "DATA";
    private static final int NAME_TABLE_COLUMN = 0;
    private static final int EXPRESSION_TABLE_COLUMN = 1;

    public CompoundRendererConfigurable(@NotNull Disposable parentDisposable) {
        super(new CardLayout());
        if (this.myProject == null) {
            this.myProject = JavaDebuggerSupport.getContextProjectForEditorFieldsInDebuggerConfigurables();
        }
        this.myRbDefaultLabel = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.default.renderer", (Object[])new Object[0]));
        this.myRbExpressionLabel = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.expression", (Object[])new Object[0]));
        ButtonGroup labelButtonsGroup = new ButtonGroup();
        labelButtonsGroup.add(this.myRbDefaultLabel);
        labelButtonsGroup.add(this.myRbExpressionLabel);
        this.myShowTypeCheckBox = new JBCheckBox(DebuggerBundle.message((String)"label.compound.renderer.configurable.show.type", (Object[])new Object[0]));
        this.myRbDefaultChildrenRenderer = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.default.renderer", (Object[])new Object[0]));
        this.myRbExpressionChildrenRenderer = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.expression", (Object[])new Object[0]));
        this.myRbListChildrenRenderer = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.expression.list", (Object[])new Object[0]));
        ButtonGroup childrenButtonGroup = new ButtonGroup();
        childrenButtonGroup.add(this.myRbDefaultChildrenRenderer);
        childrenButtonGroup.add(this.myRbExpressionChildrenRenderer);
        childrenButtonGroup.add(this.myRbListChildrenRenderer);
        this.myLabelEditor = new DebuggerExpressionTextField(this.myProject, parentDisposable, null, "ClassLabelExpression");
        this.myChildrenEditor = new DebuggerExpressionTextField(this.myProject, parentDisposable, null, "ClassChildrenExpression");
        this.myChildrenExpandedEditor = new DebuggerExpressionTextField(this.myProject, parentDisposable, null, "ClassChildrenExpression");
        JComponent myChildrenListEditor = this.createChildrenListEditor(parentDisposable);
        ItemListener updateListener = new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                CompoundRendererConfigurable.this.updateEnabledState();
            }
        };
        this.myRbExpressionLabel.addItemListener(updateListener);
        this.myRbListChildrenRenderer.addItemListener(updateListener);
        this.myRbExpressionChildrenRenderer.addItemListener(updateListener);
        this.myClassNameField = new ClassNameEditorWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                PsiClass psiClass = DebuggerUtils.getInstance().chooseClassDialog(DebuggerBundle.message((String)"title.compound.renderer.configurable.choose.renderer.reference.type", (Object[])new Object[0]), CompoundRendererConfigurable.this.myProject);
                if (psiClass != null) {
                    String qName = JVMNameUtil.getNonAnonymousClassName(psiClass);
                    CompoundRendererConfigurable.this.myClassNameField.setText(qName);
                    CompoundRendererConfigurable.this.updateContext(qName);
                }
            }
        }, this.myProject);
        this.myClassNameField.getEditorTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                CompoundRendererConfigurable.this.updateContext(CompoundRendererConfigurable.this.myClassNameField.getText());
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(DebuggerBundle.message((String)"label.compound.renderer.configurable.apply.to", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)((Object)this.myClassNameField), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(DebuggerBundle.message((String)"label.compound.renderer.configurable.when.rendering", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)this.myShowTypeCheckBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 7, 0, 0), 0, 0));
        panel.add((Component)this.myRbDefaultLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.myRbExpressionLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.myLabelEditor, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 30, 0, 0), 0, 0));
        panel.add((Component)new JLabel(DebuggerBundle.message((String)"label.compound.renderer.configurable.when.expanding", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)this.myRbDefaultChildrenRenderer, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.myRbExpressionChildrenRenderer, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.myChildrenEditor, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 30, 0, 0), 0, 0));
        this.myExpandedLabel = new JLabel(DebuggerBundle.message((String)"label.compound.renderer.configurable.test.can.expand", (Object[])new Object[0]));
        panel.add((Component)this.myExpandedLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 30, 0, 0), 0, 0));
        panel.add((Component)this.myChildrenExpandedEditor, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 30, 0, 0), 0, 0));
        panel.add((Component)this.myRbListChildrenRenderer, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)myChildrenListEditor, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(4, 30, 0, 0), 0, 0));
        this.add((Component)new JPanel(), EMPTY_PANEL_ID);
        this.add((Component)panel, DATA_PANEL_ID);
    }

    public void setRenderer(NodeRenderer renderer) {
        if (renderer instanceof CompoundReferenceRenderer) {
            this.myRenderer = (CompoundReferenceRenderer)renderer;
            this.myOriginalRenderer = (CompoundReferenceRenderer)renderer.clone();
        } else {
            this.myOriginalRenderer = null;
            this.myRenderer = null;
        }
        this.reset();
    }

    public CompoundReferenceRenderer getRenderer() {
        return this.myRenderer;
    }

    private void updateContext(final String qName) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                Project project2 = CompoundRendererConfigurable.this.myProject;
                PsiClass psiClass = project2 != null ? DebuggerUtils.findClass((String)qName, (Project)project2, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2)) : null;
                CompoundRendererConfigurable.this.myLabelEditor.setContext((PsiElement)psiClass);
                CompoundRendererConfigurable.this.myChildrenEditor.setContext((PsiElement)psiClass);
                CompoundRendererConfigurable.this.myChildrenExpandedEditor.setContext((PsiElement)psiClass);
                CompoundRendererConfigurable.this.myListChildrenEditor.setContext((PsiElement)psiClass);
                assert (project2 != null);
                PsiType type = DebuggerUtils.getType((String)qName, (Project)project2);
                CompoundRendererConfigurable.this.myLabelEditor.setThisType(type);
                CompoundRendererConfigurable.this.myChildrenEditor.setThisType(type);
                CompoundRendererConfigurable.this.myChildrenExpandedEditor.setThisType(type);
                CompoundRendererConfigurable.this.myListChildrenEditor.setThisType(type);
            }
        });
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                CompoundRendererConfigurable.this.myLabelEditor.setText(CompoundRendererConfigurable.this.myLabelEditor.getText());
                CompoundRendererConfigurable.this.myChildrenEditor.setText(CompoundRendererConfigurable.this.myChildrenEditor.getText());
                CompoundRendererConfigurable.this.myChildrenExpandedEditor.setText(CompoundRendererConfigurable.this.myChildrenExpandedEditor.getText());
                CompoundRendererConfigurable.this.myListChildrenEditor.setText(CompoundRendererConfigurable.this.myListChildrenEditor.getText());
            }
        }, ModalityState.any(), this.myProject.getDisposed());
    }

    private void updateEnabledState() {
        this.myLabelEditor.setEnabled(this.myRbExpressionLabel.isSelected());
        boolean isChildrenExpression = this.myRbExpressionChildrenRenderer.isSelected();
        this.myChildrenExpandedEditor.setEnabled(isChildrenExpression);
        this.myExpandedLabel.setEnabled(isChildrenExpression);
        this.myChildrenEditor.setEnabled(isChildrenExpression);
        this.myTable.setEnabled(this.myRbListChildrenRenderer.isSelected());
    }

    private JComponent createChildrenListEditor(@NotNull Disposable parentDisposable) {
        final MyTableModel tableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)tableModel);
        this.myListChildrenEditor = new DebuggerExpressionTextField(this.myProject, parentDisposable, null, "NamedChildrenConfigurable");
        AbstractTableCellEditor editor = new AbstractTableCellEditor(){

            public Object getCellEditorValue() {
                return CompoundRendererConfigurable.this.myListChildrenEditor.getText();
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                CompoundRendererConfigurable.this.myListChildrenEditor.setText((TextWithImports)value);
                return CompoundRendererConfigurable.this.myListChildrenEditor;
            }
        };
        this.myListChildrenEditor.registerKeyboardAction(e -> editor.stopCellEditing(), KeyStroke.getKeyStroke(10, 0), 1);
        this.myListChildrenEditor.registerKeyboardAction(e -> editor.cancelCellEditing(), KeyStroke.getKeyStroke(27, 0), 1);
        TableColumn exprColumn = this.myTable.getColumnModel().getColumn(1);
        exprColumn.setCellEditor((TableCellEditor)editor);
        exprColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            @NotNull
            public Component getTableCellRendererComponent(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                TextWithImports textWithImports = (TextWithImports)value;
                String text = textWithImports != null ? textWithImports.getText() : "";
                return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            }
        });
        return ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                tableModel.addRow("", DebuggerUtils.getInstance().createExpressionWithImports(""));
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedRow = CompoundRendererConfigurable.this.myTable.getSelectedRow();
                if (selectedRow >= 0 && selectedRow < CompoundRendererConfigurable.this.myTable.getRowCount()) {
                    CompoundRendererConfigurable.this.getTableModel().removeRow(selectedRow);
                }
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsUp((JTable)CompoundRendererConfigurable.this.myTable);
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsDown((JTable)CompoundRendererConfigurable.this.myTable);
            }
        }).createPanel();
    }

    public boolean isModified() {
        if (this.myRenderer == null) {
            return false;
        }
        CompoundReferenceRenderer cloned = (CompoundReferenceRenderer)this.myRenderer.clone();
        this.flushDataTo(cloned);
        return !DebuggerUtilsEx.externalizableEqual(cloned, this.myOriginalRenderer);
    }

    public void apply() {
        if (this.myRenderer == null) {
            return;
        }
        this.flushDataTo(this.myRenderer);
        this.myOriginalRenderer = (CompoundReferenceRenderer)this.myRenderer.clone();
    }

    private void flushDataTo(CompoundReferenceRenderer renderer) {
        LabelRenderer labelRenderer = null;
        renderer.setShowType(this.myShowTypeCheckBox.isSelected());
        if (this.myRbExpressionLabel.isSelected()) {
            labelRenderer = new LabelRenderer();
            labelRenderer.setLabelExpression(this.myLabelEditor.getText());
        }
        renderer.setLabelRenderer(labelRenderer);
        ReferenceRenderer childrenRenderer = null;
        if (this.myRbExpressionChildrenRenderer.isSelected()) {
            childrenRenderer = new ExpressionChildrenRenderer();
            childrenRenderer.setChildrenExpression(this.myChildrenEditor.getText());
            childrenRenderer.setChildrenExpandable(this.myChildrenExpandedEditor.getText());
        } else if (this.myRbListChildrenRenderer.isSelected()) {
            childrenRenderer = new EnumerationChildrenRenderer(this.getTableModel().getExpressions());
        }
        renderer.setChildrenRenderer((ChildrenRenderer)((Object)childrenRenderer));
        renderer.setClassName(this.myClassNameField.getText());
    }

    public void reset() {
        TextWithImportsImpl emptyExpressionFragment = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "");
        ((CardLayout)this.getLayout()).show(this, this.myRenderer == null ? EMPTY_PANEL_ID : DATA_PANEL_ID);
        if (this.myRenderer == null) {
            return;
        }
        String className = this.myRenderer.getClassName();
        this.myClassNameField.setText(className);
        ValueLabelRenderer labelRenderer = this.myRenderer.getLabelRenderer();
        ChildrenRenderer childrenRenderer = this.myRenderer.getChildrenRenderer();
        NodeRendererSettings rendererSettings = NodeRendererSettings.getInstance();
        this.myShowTypeCheckBox.setSelected(this.myRenderer.isShowType());
        if (rendererSettings.isBase(labelRenderer)) {
            this.myLabelEditor.setText(emptyExpressionFragment);
            this.myRbDefaultLabel.setSelected(true);
        } else {
            this.myRbExpressionLabel.setSelected(true);
            this.myLabelEditor.setText(((LabelRenderer)labelRenderer).getLabelExpression());
        }
        if (rendererSettings.isBase(childrenRenderer)) {
            this.myRbDefaultChildrenRenderer.setSelected(true);
            this.myChildrenEditor.setText(emptyExpressionFragment);
            this.myChildrenExpandedEditor.setText(emptyExpressionFragment);
            this.getTableModel().clear();
        } else if (childrenRenderer instanceof ExpressionChildrenRenderer) {
            this.myRbExpressionChildrenRenderer.setSelected(true);
            ExpressionChildrenRenderer exprRenderer = (ExpressionChildrenRenderer)childrenRenderer;
            this.myChildrenEditor.setText(exprRenderer.getChildrenExpression());
            this.myChildrenExpandedEditor.setText(exprRenderer.getChildrenExpandable());
            this.getTableModel().clear();
        } else {
            this.myRbListChildrenRenderer.setSelected(true);
            this.myChildrenEditor.setText(emptyExpressionFragment);
            this.myChildrenExpandedEditor.setText(emptyExpressionFragment);
            if (childrenRenderer instanceof EnumerationChildrenRenderer) {
                this.getTableModel().init(((EnumerationChildrenRenderer)childrenRenderer).getChildren());
            } else {
                this.getTableModel().clear();
            }
        }
        this.updateEnabledState();
        this.updateContext(className);
    }

    private MyTableModel getTableModel() {
        return (MyTableModel)this.myTable.getModel();
    }

    private static class ClassNameEditorWithBrowseButton
    extends ReferenceEditorWithBrowseButton {
        private ClassNameEditorWithBrowseButton(ActionListener browseActionListener, final Project project2) {
            super(browseActionListener, project2, new Function<String, Document>(){

                public Document fun(String s) {
                    PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project2).findPackage("");
                    PsiJavaCodeReferenceCodeFragment fragment = JavaCodeFragmentFactory.getInstance((Project)project2).createReferenceCodeFragment(s, (PsiElement)defaultPackage, true, true);
                    fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
                    return PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)fragment);
                }
            }, "");
        }
    }

    private static final class MyTableModel
    extends AbstractTableModel {
        private final List<Row> myData = new ArrayList<Row>();

        public void init(List<Pair<String, TextWithImports>> data) {
            this.myData.clear();
            for (Pair<String, TextWithImports> pair : data) {
                this.myData.add(new Row((String)pair.getFirst(), (TextWithImports)pair.getSecond()));
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myData.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @NotNull
        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return TextWithImports.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.getRowCount()) {
                return null;
            }
            Row row = this.myData.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return row.name;
                }
                case 1: {
                    return row.value;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (rowIndex >= this.getRowCount()) {
                return;
            }
            Row row = this.myData.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    row.name = (String)aValue;
                    break;
                }
                case 1: {
                    row.value = (TextWithImports)aValue;
                }
            }
        }

        @Override
        @NotNull
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return DebuggerBundle.message((String)"label.compound.renderer.configurable.table.header.name", (Object[])new Object[0]);
                }
                case 1: {
                    return DebuggerBundle.message((String)"label.compound.renderer.configurable.table.header.expression", (Object[])new Object[0]);
                }
            }
            return "";
        }

        public void addRow(String name, TextWithImports expressionWithImports) {
            this.myData.add(new Row(name, expressionWithImports));
            int lastRow = this.myData.size() - 1;
            this.fireTableRowsInserted(lastRow, lastRow);
        }

        public void removeRow(int row) {
            if (row >= 0 && row < this.myData.size()) {
                this.myData.remove(row);
                this.fireTableRowsDeleted(row, row);
            }
        }

        public void clear() {
            this.myData.clear();
            this.fireTableDataChanged();
        }

        public List<Pair<String, TextWithImports>> getExpressions() {
            ArrayList<Pair<String, TextWithImports>> pairs = new ArrayList<Pair<String, TextWithImports>>(this.myData.size());
            for (Row row : this.myData) {
                pairs.add((Pair<String, TextWithImports>)Pair.create((Object)row.name, (Object)row.value));
            }
            return pairs;
        }

        private static final class Row {
            public String name;
            public TextWithImports value;

            public Row(String name, TextWithImports value) {
                this.name = name;
                this.value = value;
            }
        }
    }
}

