/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.InstructionParser;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class LocalVariablesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.jdi.LocalVariablesUtil");
    private static final boolean ourInitializationOk;
    private static Class<?> ourSlotInfoClass;
    private static Constructor<?> slotInfoConstructor;
    private static Method ourEnqueueMethod;
    private static Method ourWaitForReplyMethod;
    private static final boolean ourInitializationOkSet;
    private static Class<?> ourSlotInfoClassSet;
    private static Constructor<?> slotInfoConstructorSet;
    private static Method ourEnqueueMethodSet;
    private static Method ourWaitForReplyMethodSet;

    public static Map<DecompiledLocalVariable, Value> fetchValues(@NotNull StackFrameProxyImpl frameProxy, DebugProcess process) throws Exception {
        LinkedHashMap<DecompiledLocalVariable, Value> map = new LinkedHashMap<DecompiledLocalVariable, Value>();
        com.sun.jdi.Method method = frameProxy.location().method();
        int firstLocalVariableSlot = LocalVariablesUtil.getFirstLocalsSlot(method);
        MultiMap<Integer, String> namesMap = LocalVariablesUtil.calcNames(new SimpleStackFrameContext(frameProxy, process), firstLocalVariableSlot);
        int slot = 0;
        List<String> typeNames = method.argumentTypeNames();
        List<Value> argValues = frameProxy.getArgumentValues();
        for (int i = 0; i < argValues.size(); ++i) {
            map.put(new DecompiledLocalVariable(slot, true, null, namesMap.get((Object)slot)), argValues.get(i));
            slot += LocalVariablesUtil.getTypeSlotSize(typeNames.get(i));
        }
        if (!ourInitializationOk) {
            return map;
        }
        List<DecompiledLocalVariable> vars = LocalVariablesUtil.collectVariablesFromBytecode(frameProxy, namesMap);
        StackFrame frame = frameProxy.getStackFrame();
        for (int size = vars.size(); size > 0; --size) {
            try {
                return LocalVariablesUtil.fetchSlotValues(map, vars.subList(0, size), frame);
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                continue;
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<DecompiledLocalVariable, Value> fetchSlotValues(Map<DecompiledLocalVariable, Value> map, List<DecompiledLocalVariable> vars, StackFrame frame) throws Exception {
        Object ps;
        Object vmState;
        Long frameId = (Long)ReflectionUtil.getField(frame.getClass(), (Object)frame, Long.TYPE, (String)"id");
        VirtualMachine vm = frame.virtualMachine();
        Method stateMethod = ReflectionUtil.getDeclaredMethod(vm.getClass(), (String)"state", (Class[])new Class[0]);
        Object slotInfoArray = LocalVariablesUtil.createSlotInfoArray(vars);
        Object object = vmState = stateMethod.invoke((Object)vm, new Object[0]);
        synchronized (object) {
            ps = ourEnqueueMethod.invoke(null, vm, frame.thread(), frameId, slotInfoArray);
        }
        Object reply = ourWaitForReplyMethod.invoke(null, vm, ps);
        Value[] values = (Value[])ReflectionUtil.getField(reply.getClass(), (Object)reply, Value[].class, (String)"values");
        if (vars.size() != values.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        int idx = 0;
        for (DecompiledLocalVariable var : vars) {
            map.put(var, values[idx++]);
        }
        return map;
    }

    public static boolean canSetValues() {
        return ourInitializationOkSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValue(StackFrame frame, int slot, Value value) throws EvaluateException {
        try {
            Object ps;
            Object vmState;
            Long frameId = (Long)ReflectionUtil.getField(frame.getClass(), (Object)frame, Long.TYPE, (String)"id");
            VirtualMachine vm = frame.virtualMachine();
            Method stateMethod = ReflectionUtil.getDeclaredMethod(vm.getClass(), (String)"state", (Class[])new Class[0]);
            Object slotInfoArray = LocalVariablesUtil.createSlotInfoArraySet(slot, value);
            Object object = vmState = stateMethod.invoke((Object)vm, new Object[0]);
            synchronized (object) {
                ps = ourEnqueueMethodSet.invoke(null, vm, frame.thread(), frameId, slotInfoArray);
            }
            ourWaitForReplyMethodSet.invoke(null, vm, ps);
        }
        catch (Exception e) {
            throw new EvaluateException("Unable to set value", (Throwable)e);
        }
    }

    private static Object createSlotInfoArraySet(int slot, Value value) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object arrayInstance = Array.newInstance(ourSlotInfoClassSet, 1);
        Array.set(arrayInstance, 0, slotInfoConstructorSet.newInstance(slot, value));
        return arrayInstance;
    }

    private static Object createSlotInfoArray(Collection<DecompiledLocalVariable> vars) throws Exception {
        Object arrayInstance = Array.newInstance(ourSlotInfoClass, vars.size());
        int idx = 0;
        for (DecompiledLocalVariable var : vars) {
            Object info = slotInfoConstructor.newInstance(var.getSlot(), (byte)var.getSignature().charAt(0));
            Array.set(arrayInstance, idx++, info);
        }
        return arrayInstance;
    }

    private static Method getDeclaredMethodByName(Class aClass, String methodName) throws NoSuchMethodException {
        for (Method method : aClass.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            method.setAccessible(true);
            return method;
        }
        throw new NoSuchMethodException(aClass.getName() + "." + methodName);
    }

    @NotNull
    private static List<DecompiledLocalVariable> collectVariablesFromBytecode(StackFrameProxyImpl frame, final MultiMap<Integer, String> namesMap) {
        if (!frame.getVirtualMachine().canGetBytecodes()) {
            return Collections.emptyList();
        }
        try {
            Location location = frame.location();
            LOG.assertTrue(location != null);
            com.sun.jdi.Method method = location.method();
            Location methodLocation = method.location();
            if (methodLocation == null || methodLocation.codeIndex() < 0L) {
                return Collections.emptyList();
            }
            byte[] bytecodes = method.bytecodes();
            if (bytecodes != null && bytecodes.length > 0) {
                final int firstLocalVariableSlot = LocalVariablesUtil.getFirstLocalsSlot(method);
                final HashMap usedVars = new HashMap();
                new InstructionParser(bytecodes, location.codeIndex()){

                    @Override
                    protected void localVariableInstructionFound(int opcode, int slot, String typeSignature) {
                        DecompiledLocalVariable variable;
                        if (!(slot < firstLocalVariableSlot || (variable = (DecompiledLocalVariable)usedVars.get(slot)) != null && typeSignature.equals(variable.getSignature()))) {
                            variable = new DecompiledLocalVariable(slot, false, typeSignature, namesMap.get((Object)slot));
                            usedVars.put(slot, variable);
                        }
                    }
                }.parse();
                if (usedVars.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<DecompiledLocalVariable> vars = new ArrayList<DecompiledLocalVariable>(usedVars.values());
                Collections.sort(vars, DecompiledLocalVariable.COMPARATOR);
                return vars;
            }
        }
        catch (UnsupportedOperationException location) {
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static MultiMap<Integer, String> calcNames(final @NotNull StackFrameContext context, final int firstLocalsSlot) {
        return (MultiMap)ApplicationManager.getApplication().runReadAction((Computable)new Computable<MultiMap<Integer, String>>(){

            public MultiMap<Integer, String> compute() {
                PsiElement element;
                PsiElement method;
                SourcePosition position = ContextUtil.getSourcePosition(context);
                if (position != null && (method = DebuggerUtilsEx.getContainingMethod(element = position.getElementAt())) != null) {
                    MultiMap res = new MultiMap();
                    int slot = Math.max(0, firstLocalsSlot - LocalVariablesUtil.getFirstLocalsSlot(method));
                    for (PsiParameter parameter : DebuggerUtilsEx.getParameters(method)) {
                        res.putValue((Object)slot, (Object)parameter.getName());
                        slot += LocalVariablesUtil.getTypeSlotSize(parameter.getType());
                    }
                    PsiElement body = DebuggerUtilsEx.getBody(method);
                    if (body != null) {
                        try {
                            body.accept((PsiElementVisitor)new LocalVariableNameFinder(firstLocalsSlot, (MultiMap<Integer, String>)res, element));
                        }
                        catch (Exception e) {
                            LOG.info((Throwable)e);
                        }
                    }
                    return res;
                }
                return MultiMap.empty();
            }
        });
    }

    private static int getFirstLocalsSlot(PsiElement method) {
        int startSlot = 0;
        if (method instanceof PsiModifierListOwner) {
            startSlot = ((PsiModifierListOwner)method).hasModifierProperty("static") ? 0 : 1;
        }
        for (PsiParameter parameter : DebuggerUtilsEx.getParameters(method)) {
            startSlot += LocalVariablesUtil.getTypeSlotSize(parameter.getType());
        }
        return startSlot;
    }

    private static int getTypeSlotSize(PsiType varType) {
        if (PsiType.DOUBLE.equals((Object)varType) || PsiType.LONG.equals((Object)varType)) {
            return 2;
        }
        return 1;
    }

    private static int getFirstLocalsSlot(com.sun.jdi.Method method) {
        int firstLocalVariableSlot = method.isStatic() ? 0 : 1;
        for (String type : method.argumentTypeNames()) {
            firstLocalVariableSlot += LocalVariablesUtil.getTypeSlotSize(type);
        }
        return firstLocalVariableSlot;
    }

    private static int getTypeSlotSize(String name) {
        if ("double".equals(name) || "long".equals(name)) {
            return 2;
        }
        return 1;
    }

    static {
        boolean success = false;
        try {
            String GetValuesClassName = "com.sun.tools.jdi.JDWP$StackFrame$GetValues";
            ourSlotInfoClass = Class.forName(GetValuesClassName + "$SlotInfo");
            slotInfoConstructor = ourSlotInfoClass.getDeclaredConstructor(Integer.TYPE, Byte.TYPE);
            slotInfoConstructor.setAccessible(true);
            Class<?> ourGetValuesClass = Class.forName(GetValuesClassName);
            ourEnqueueMethod = LocalVariablesUtil.getDeclaredMethodByName(ourGetValuesClass, "enqueueCommand");
            ourWaitForReplyMethod = LocalVariablesUtil.getDeclaredMethodByName(ourGetValuesClass, "waitForReply");
            success = true;
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        ourInitializationOk = success;
        success = false;
        try {
            String setValuesClassName = "com.sun.tools.jdi.JDWP$StackFrame$SetValues";
            ourSlotInfoClassSet = Class.forName(setValuesClassName + "$SlotInfo");
            slotInfoConstructorSet = ourSlotInfoClassSet.getDeclaredConstructors()[0];
            slotInfoConstructorSet.setAccessible(true);
            Class<?> ourGetValuesClassSet = Class.forName(setValuesClassName);
            ourEnqueueMethodSet = LocalVariablesUtil.getDeclaredMethodByName(ourGetValuesClassSet, "enqueueCommand");
            ourWaitForReplyMethodSet = LocalVariablesUtil.getDeclaredMethodByName(ourGetValuesClassSet, "waitForReply");
            success = true;
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        ourInitializationOkSet = success;
    }

    private static class LocalVariableNameFinder
    extends JavaRecursiveElementVisitor {
        private final MultiMap<Integer, String> myNames;
        private int myCurrentSlotIndex;
        private final PsiElement myElement;
        private final Stack<Integer> myIndexStack;
        private boolean myReached = false;

        public LocalVariableNameFinder(int startSlot, MultiMap<Integer, String> names, PsiElement element) {
            this.myNames = names;
            this.myCurrentSlotIndex = startSlot;
            this.myElement = element;
            this.myIndexStack = new Stack();
        }

        private boolean shouldVisit(PsiElement scope) {
            return !this.myReached && PsiTreeUtil.isContextAncestor((PsiElement)scope, (PsiElement)this.myElement, (boolean)false);
        }

        public void visitElement(PsiElement element) {
            if (element == this.myElement) {
                this.myReached = true;
            } else {
                super.visitElement(element);
            }
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            if (!this.myReached) {
                this.appendName(variable.getName());
                this.myCurrentSlotIndex += LocalVariablesUtil.getTypeSlotSize(variable.getType());
            }
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement2) {
            if (this.shouldVisit((PsiElement)statement2)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    this.appendName("<monitor>");
                    ++this.myCurrentSlotIndex;
                    super.visitSynchronizedStatement(statement2);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        private void appendName(String varName) {
            this.myNames.putValue((Object)this.myCurrentSlotIndex, (Object)varName);
        }

        public void visitCodeBlock(PsiCodeBlock block) {
            if (this.shouldVisit((PsiElement)block)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitCodeBlock(block);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitForStatement(PsiForStatement statement2) {
            if (this.shouldVisit((PsiElement)statement2)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitForStatement(statement2);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            if (this.shouldVisit((PsiElement)statement2)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitForeachStatement(statement2);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitCatchSection(PsiCatchSection section) {
            if (this.shouldVisit((PsiElement)section)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitCatchSection(section);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitResourceList(PsiResourceList resourceList) {
            if (this.shouldVisit((PsiElement)resourceList)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitResourceList(resourceList);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitClass(PsiClass aClass) {
        }
    }
}

