/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.descriptors.data;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.ui.impl.watch.MethodReturnValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodReturnValueData
extends DescriptorData<MethodReturnValueDescriptorImpl> {
    @Nullable
    private final Value myReturnValue;
    @NotNull
    private final Method myMethod;

    public MethodReturnValueData(@NotNull Method method, @Nullable Value returnValue) {
        this.myMethod = method;
        this.myReturnValue = returnValue;
    }

    @Nullable
    public Value getReturnValue() {
        return this.myReturnValue;
    }

    @NotNull
    public Method getMethod() {
        return this.myMethod;
    }

    @Override
    protected MethodReturnValueDescriptorImpl createDescriptorImpl(@NotNull Project project2) {
        return new MethodReturnValueDescriptorImpl(project2, this.myMethod, this.myReturnValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodReturnValueData that = (MethodReturnValueData)o;
        if (!this.myMethod.equals(that.myMethod)) {
            return false;
        }
        return !(this.myReturnValue != null ? !this.myReturnValue.equals(that.myReturnValue) : that.myReturnValue != null);
    }

    @Override
    public int hashCode() {
        int result = this.myReturnValue != null ? this.myReturnValue.hashCode() : 0;
        result = 31 * result + this.myMethod.hashCode();
        return result;
    }

    @Override
    public DisplayKey<MethodReturnValueDescriptorImpl> getDisplayKey() {
        return new MethodReturnValueDisplayKey(this.myMethod, this.myReturnValue);
    }

    private static final class MethodReturnValueDisplayKey
    extends Pair<Method, Value>
    implements DisplayKey<MethodReturnValueDescriptorImpl> {
        public MethodReturnValueDisplayKey(@NotNull Method method, @Nullable Value value) {
            super((Object)method, (Object)value);
        }
    }
}

