/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EvaluationContextImpl
implements EvaluationContext {
    private final Value myThisObject;
    private final SuspendContextImpl mySuspendContext;
    private final StackFrameProxyImpl myFrameProxy;
    private boolean myAutoLoadClasses = true;
    private ClassLoaderReference myClassLoader;

    public EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, StackFrameProxyImpl frameProxy, @Nullable Value thisObject) {
        this.myThisObject = thisObject;
        this.myFrameProxy = frameProxy;
        this.mySuspendContext = suspendContext;
    }

    @Nullable
    public Value getThisObject() {
        return this.myThisObject;
    }

    @NotNull
    public SuspendContextImpl getSuspendContext() {
        return this.mySuspendContext;
    }

    public StackFrameProxyImpl getFrameProxy() {
        return this.myFrameProxy;
    }

    @NotNull
    public DebugProcessImpl getDebugProcess() {
        return this.getSuspendContext().getDebugProcess();
    }

    public DebuggerManagerThreadImpl getManagerThread() {
        return this.getDebugProcess().getManagerThread();
    }

    public Project getProject() {
        DebugProcessImpl debugProcess = this.getDebugProcess();
        return debugProcess.getProject();
    }

    public EvaluationContextImpl createEvaluationContext(Value value) {
        EvaluationContextImpl copy = new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), value);
        copy.setAutoLoadClasses(this.myAutoLoadClasses);
        return copy;
    }

    @Nullable
    public ClassLoaderReference getClassLoader() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myClassLoader != null) {
            return this.myClassLoader;
        }
        return this.myFrameProxy != null ? this.myFrameProxy.getClassLoader() : null;
    }

    public void setClassLoader(ClassLoaderReference classLoader) {
        this.myClassLoader = classLoader;
    }

    public boolean isAutoLoadClasses() {
        return this.myAutoLoadClasses;
    }

    public void setAutoLoadClasses(boolean autoLoadClasses) {
        this.myAutoLoadClasses = autoLoadClasses;
    }
}

