/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.progress.util.ProgressWindowWithNotification;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public abstract class JavaValueModifier
extends XValueModifier {
    private final JavaValue myJavaValue;

    public JavaValueModifier(JavaValue javaValue) {
        this.myJavaValue = javaValue;
    }

    public void calculateInitialValueEditorText(final XValueModifier.XInitialValueCallback callback) {
        final Value value = this.myJavaValue.getDescriptor().getValue();
        if (value instanceof PrimitiveValue) {
            String valueString = this.myJavaValue.getValueString();
            int pos = valueString.lastIndexOf(40);
            if (pos > 1) {
                valueString = valueString.substring(0, pos).trim();
            }
            callback.setValue(valueString);
        } else if (value instanceof StringReference) {
            final EvaluationContextImpl evaluationContext = this.myJavaValue.getEvaluationContext();
            evaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(evaluationContext.getSuspendContext()){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.NORMAL;
                }

                @Override
                public void contextAction() throws Exception {
                    callback.setValue(StringUtil.wrapWithDoubleQuote((String)DebuggerUtils.translateStringValue((String)DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)value))));
                }
            });
        } else {
            callback.setValue(null);
        }
    }

    protected static void update(final DebuggerContextImpl context) {
        DebuggerInvocationUtil.swingInvokeLater(context.getProject(), new Runnable(){

            @Override
            public void run() {
                DebuggerSession session = context.getDebuggerSession();
                if (session != null) {
                    session.refresh(false);
                }
            }
        });
    }

    protected abstract void setValueImpl(@NotNull String var1, @NotNull XValueModifier.XModificationCallback var2);

    public void setValue(@NotNull String expression, @NotNull XValueModifier.XModificationCallback callback) {
        ValueDescriptorImpl descriptor = this.myJavaValue.getDescriptor();
        if (!descriptor.canSetValue()) {
            return;
        }
        if (this.myJavaValue.getEvaluationContext().getSuspendContext().isResumed()) {
            callback.errorOccurred(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
            return;
        }
        this.setValueImpl(expression, callback);
    }

    protected static Value preprocessValue(EvaluationContextImpl context, Value value, Type varType) throws EvaluateException {
        String v;
        if (value != null && "java.lang.String".equals(varType.name()) && !(value instanceof StringReference) && (v = DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)value)) != null) {
            value = context.getSuspendContext().getDebugProcess().getVirtualMachineProxy().mirrorOf(v);
        }
        if (value instanceof DoubleValue) {
            double dValue = ((DoubleValue)value).doubleValue();
            if (varType instanceof FloatType && (double)1.4E-45f <= dValue && dValue <= 3.4028234663852886E38) {
                value = context.getSuspendContext().getDebugProcess().getVirtualMachineProxy().mirrorOf((float)dValue);
            }
        }
        if (value != null) {
            if (varType instanceof PrimitiveType) {
                if (!(value instanceof PrimitiveValue)) {
                    value = (Value)new UnBoxingEvaluator(new IdentityEvaluator(value)).evaluate(context);
                }
            } else if (varType instanceof ReferenceType && value instanceof PrimitiveValue) {
                value = (Value)new BoxingEvaluator(new IdentityEvaluator(value)).evaluate(context);
            }
        }
        return value;
    }

    private static void setValue(String expressionToShow, ExpressionEvaluator evaluator, EvaluationContextImpl evaluationContext, SetValueRunnable setValueRunnable) throws EvaluateException {
        try {
            Value value = evaluator.evaluate((EvaluationContext)evaluationContext);
            setValueRunnable.setValue(evaluationContext, value);
        }
        catch (IllegalArgumentException ex) {
            throw EvaluateExceptionUtil.createEvaluateException((String)ex.getMessage());
        }
        catch (InvalidTypeException ex) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.type.mismatch", (Object[])new Object[0]));
        }
        catch (IncompatibleThreadStateException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        catch (ClassNotLoadedException ex) {
            if (!evaluationContext.isAutoLoadClasses()) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)ex);
            }
            try {
                ReferenceType refType = setValueRunnable.loadClass(evaluationContext, ex.className());
                if (refType != null) {
                    JavaValueModifier.setValue(expressionToShow, evaluator, evaluationContext, setValueRunnable);
                }
            }
            catch (InvocationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (ClassNotLoadedException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (IncompatibleThreadStateException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (InvalidTypeException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (ObjectCollectedException e) {
                throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
            }
        }
    }

    protected void set(final @NotNull String expression, final XValueModifier.XModificationCallback callback, DebuggerContextImpl debuggerContext, final SetValueRunnable setValueRunnable) {
        final ProgressWindowWithNotification progressWindow = new ProgressWindowWithNotification(true, debuggerContext.getProject());
        final EvaluationContextImpl evaluationContext = this.myJavaValue.getEvaluationContext();
        DebuggerContextCommandImpl askSetAction = new DebuggerContextCommandImpl(debuggerContext){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            public void threadAction() {
                try {
                    final Project project2 = evaluationContext.getProject();
                    ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(project2, new EvaluatingComputable<ExpressionEvaluator>(){

                        @Override
                        public ExpressionEvaluator compute() throws EvaluateException {
                            return EvaluatorBuilderImpl.build(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression), ContextUtil.getContextElement((StackFrameContext)evaluationContext), ContextUtil.getSourcePosition((StackFrameContext)evaluationContext), project2);
                        }
                    });
                    JavaValueModifier.setValue(expression, evaluator, evaluationContext, new SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException, IncompatibleThreadStateException {
                            if (!progressWindow.isCanceled()) {
                                setValueRunnable.setValue(evaluationContext, newValue);
                            }
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String className) throws InvocationException, ClassNotLoadedException, EvaluateException, IncompatibleThreadStateException, InvalidTypeException {
                            return setValueRunnable.loadClass(evaluationContext, className);
                        }
                    });
                    callback.valueModified();
                }
                catch (EvaluateException e) {
                    callback.errorOccurred(e.getMessage());
                }
            }
        };
        progressWindow.setTitle(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
        evaluationContext.getDebugProcess().getManagerThread().startProgress(askSetAction, progressWindow);
    }

    private static String getDisplayableString(PrimitiveValue value, boolean showAsHex) {
        if (value instanceof CharValue) {
            long longValue = value.longValue();
            return showAsHex ? "0x" + Long.toHexString(longValue).toUpperCase() : Long.toString(longValue);
        }
        if (value instanceof ByteValue) {
            byte val = value.byteValue();
            String strValue = Integer.toHexString(val).toUpperCase();
            if (strValue.length() > 2) {
                strValue = strValue.substring(strValue.length() - 2);
            }
            return showAsHex ? "0x" + strValue : value.toString();
        }
        if (value instanceof ShortValue) {
            short val = value.shortValue();
            String strValue = Integer.toHexString(val).toUpperCase();
            if (strValue.length() > 4) {
                strValue = strValue.substring(strValue.length() - 4);
            }
            return showAsHex ? "0x" + strValue : value.toString();
        }
        if (value instanceof IntegerValue) {
            int val = value.intValue();
            return showAsHex ? "0x" + Integer.toHexString(val).toUpperCase() : value.toString();
        }
        if (value instanceof LongValue) {
            long val = value.longValue();
            return showAsHex ? "0x" + Long.toHexString(val).toUpperCase() + "L" : value.toString() + "L";
        }
        return DebuggerUtils.translateStringValue((String)value.toString());
    }

    protected static interface SetValueRunnable {
        public void setValue(EvaluationContextImpl var1, Value var2) throws ClassNotLoadedException, InvalidTypeException, EvaluateException, IncompatibleThreadStateException;

        public ReferenceType loadClass(EvaluationContextImpl var1, String var2) throws EvaluateException, InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException;
    }
}

