/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaExceptionBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaWildcardMethodBreakpointType;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaBreakpointHandler
extends XBreakpointHandler {
    protected final DebugProcessImpl myProcess;

    public JavaBreakpointHandler(@NotNull Class<? extends XBreakpointType<?, ?>> breakpointTypeClass, DebugProcessImpl process) {
        super(breakpointTypeClass);
        this.myProcess = process;
    }

    @Nullable
    protected Breakpoint createJavaBreakpoint(@NotNull XBreakpoint xBreakpoint) {
        return null;
    }

    public void registerBreakpoint(@NotNull XBreakpoint breakpoint) {
        Breakpoint javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint);
        if (javaBreakpoint == null) {
            javaBreakpoint = this.createJavaBreakpoint(breakpoint);
            breakpoint.putUserData(Breakpoint.DATA_KEY, (Object)javaBreakpoint);
        }
        if (javaBreakpoint != null) {
            final Breakpoint bpt = javaBreakpoint;
            BreakpointManager.addBreakpoint(bpt);
            this.myProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    bpt.createRequest(JavaBreakpointHandler.this.myProcess);
                }

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }
            });
        }
    }

    public void unregisterBreakpoint(@NotNull XBreakpoint breakpoint, boolean temporary) {
        final Breakpoint javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint);
        if (javaBreakpoint != null) {
            this.myProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    JavaBreakpointHandler.this.myProcess.getRequestsManager().deleteRequest(javaBreakpoint);
                }

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }
            });
        }
    }

    public static class JavaFieldBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaFieldBreakpointHandler(DebugProcessImpl process) {
            super(JavaFieldBreakpointType.class, process);
        }
    }

    public static class JavaWildcardBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaWildcardBreakpointHandler(DebugProcessImpl process) {
            super(JavaWildcardMethodBreakpointType.class, process);
        }
    }

    public static class JavaMethodBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaMethodBreakpointHandler(DebugProcessImpl process) {
            super(JavaMethodBreakpointType.class, process);
        }
    }

    public static class JavaExceptionBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaExceptionBreakpointHandler(DebugProcessImpl process) {
            super(JavaExceptionBreakpointType.class, process);
        }
    }

    public static class JavaLineBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaLineBreakpointHandler(DebugProcessImpl process) {
            super(JavaLineBreakpointType.class, process);
        }
    }
}

