/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.impl.ui.TextViewer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XFetchValueActionBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ViewTextAction
extends XFetchValueActionBase {
    @Override
    protected void handle(Project project2, String value, XDebuggerTree tree) {
    }

    @Override
    @NotNull
    protected XFetchValueActionBase.ValueCollector createCollector(@NotNull AnActionEvent e) {
        return new XFetchValueActionBase.ValueCollector(XDebuggerTree.getTree(e.getDataContext())){
            MyDialog dialog;
            {
                this.dialog = null;
            }

            @Override
            public void handleInCollector(Project project2, String value, XDebuggerTree tree) {
                if (this.dialog == null) {
                    this.dialog = new MyDialog(project2);
                    this.dialog.setTitle("View Text");
                    this.dialog.show();
                }
                this.dialog.setText(StringUtil.unquoteString((String)value));
            }
        };
    }

    private static class MyDialog
    extends DialogWrapper {
        private final EditorTextField myTextViewer;

        private MyDialog(Project project2) {
            super(project2, false);
            this.setModal(false);
            this.setCancelButtonText("Close");
            this.setCrossClosesWindow(true);
            this.myTextViewer = new TextViewer(project2, true, true);
            this.init();
        }

        public void setText(String text) {
            this.myTextViewer.setText(text);
        }

        @NotNull
        protected Action[] createActions() {
            return new Action[]{this.getCancelAction()};
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.debugger.actions.ViewTextAction";
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)((Object)this.myTextViewer), "Center");
            panel.setPreferredSize((Dimension)JBUI.size((int)300, (int)200));
            return panel;
        }
    }
}

