/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class PsiMethodListPopupStep
implements ListPopupStep<SmartStepTarget> {
    private final List<SmartStepTarget> myTargets;
    private final OnChooseRunnable myStepRunnable;
    private final ScopeHighlighter myScopeHighlighter;

    public PsiMethodListPopupStep(Editor editor, List<SmartStepTarget> targets, OnChooseRunnable stepRunnable) {
        this.myTargets = targets;
        this.myScopeHighlighter = new ScopeHighlighter(editor);
        this.myStepRunnable = stepRunnable;
    }

    @NotNull
    public ScopeHighlighter getScopeHighlighter() {
        return this.myScopeHighlighter;
    }

    @NotNull
    public List<SmartStepTarget> getValues() {
        return this.myTargets;
    }

    public boolean isSelectable(SmartStepTarget value) {
        return true;
    }

    public Icon getIconFor(SmartStepTarget avalue) {
        return avalue.getIcon();
    }

    @NotNull
    public String getTextFor(SmartStepTarget value) {
        return value.getPresentation();
    }

    public ListSeparator getSeparatorAbove(SmartStepTarget value) {
        return null;
    }

    public int getDefaultOptionIndex() {
        return 0;
    }

    public String getTitle() {
        return DebuggerBundle.message((String)"title.smart.step.popup", (Object[])new Object[0]);
    }

    public PopupStep onChosen(SmartStepTarget selectedValue, boolean finalChoice) {
        if (finalChoice) {
            this.myScopeHighlighter.dropHighlight();
            this.myStepRunnable.execute(selectedValue);
        }
        return FINAL_CHOICE;
    }

    public Runnable getFinalRunnable() {
        return null;
    }

    public boolean hasSubstep(SmartStepTarget selectedValue) {
        return false;
    }

    public void canceled() {
        this.myScopeHighlighter.dropHighlight();
    }

    public boolean isMnemonicsNavigationEnabled() {
        return false;
    }

    public MnemonicNavigationFilter<SmartStepTarget> getMnemonicNavigationFilter() {
        return null;
    }

    public boolean isSpeedSearchEnabled() {
        return false;
    }

    public SpeedSearchFilter<SmartStepTarget> getSpeedSearchFilter() {
        return null;
    }

    public boolean isAutoSelectionEnabled() {
        return false;
    }

    public static interface OnChooseRunnable {
        public void execute(SmartStepTarget var1);
    }
}

