/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CorePackageIndex
extends PackageIndex {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.core.CorePackageIndex");
    private final List<VirtualFile> myClasspath = new ArrayList<VirtualFile>();

    private List<VirtualFile> roots() {
        return this.myClasspath;
    }

    private List<VirtualFile> findDirectoriesByPackageName(String packageName) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        String dirName = packageName.replace(".", "/");
        for (VirtualFile root : this.roots()) {
            VirtualFile classDir = root.findFileByRelativePath(dirName);
            if (classDir == null) continue;
            result.add(classDir);
        }
        return result;
    }

    public VirtualFile[] getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        return (VirtualFile[])this.getDirsByPackageName(packageName, includeLibrarySources).toArray((Object[])VirtualFile.EMPTY_ARRAY);
    }

    public Query<VirtualFile> getDirsByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        return new CollectionQuery(this.findDirectoriesByPackageName(packageName));
    }

    public void addToClasspath(VirtualFile root) {
        this.myClasspath.add(root);
    }
}

