/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreModuleScopeProvider;
import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ModulePathMacroManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.ModuleFileIndexImpl;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreModule
extends MockComponentManager
implements ModuleEx {
    private final String myPath;
    @NotNull
    private final Disposable myLifetime;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ModuleScopeProvider myModuleScopeProvider;

    public CoreModule(@NotNull Disposable parentDisposable, @NotNull Project project2, String moduleFilePath) {
        super(project2.getPicoContainer(), parentDisposable);
        this.myLifetime = parentDisposable;
        this.myProject = project2;
        this.myPath = moduleFilePath;
        Extensions.instantiateArea((String)"IDEA_MODULE", (AreaInstance)this, null);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                Extensions.disposeArea((AreaInstance)CoreModule.this);
            }
        });
        this.initModuleExtensions();
        final ModuleRootManagerImpl moduleRootManager = new ModuleRootManagerImpl(this, ProjectRootManagerImpl.getInstanceImpl(project2), VirtualFilePointerManager.getInstance()){

            @Override
            public void loadState(ModuleRootManagerImpl.ModuleRootManagerState object) {
                this.loadState(object, false);
            }
        };
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                moduleRootManager.disposeComponent();
            }
        });
        this.getPicoContainer().registerComponentInstance(ModuleRootManager.class, (Object)moduleRootManager);
        this.getPicoContainer().registerComponentInstance(PathMacroManager.class, (Object)this.createModulePathMacroManager(project2));
        this.getPicoContainer().registerComponentInstance(ModuleFileIndex.class, (Object)this.createModuleFileIndex(project2));
        this.myModuleScopeProvider = this.createModuleScopeProvider();
    }

    protected void initModuleExtensions() {
    }

    protected <T> void addModuleExtension(ExtensionPointName<T> name, final T extension) {
        final ExtensionPoint extensionPoint = Extensions.getArea((AreaInstance)this).getExtensionPoint(name);
        extensionPoint.registerExtension(extension);
        Disposer.register((Disposable)this.myLifetime, (Disposable)new Disposable(){

            public void dispose() {
                extensionPoint.unregisterExtension(extension);
            }
        });
    }

    protected ModuleScopeProvider createModuleScopeProvider() {
        return new CoreModuleScopeProvider();
    }

    protected PathMacroManager createModulePathMacroManager(@NotNull Project project2) {
        return new ModulePathMacroManager(PathMacros.getInstance(), this);
    }

    protected ModuleFileIndex createModuleFileIndex(@NotNull Project project2) {
        return new ModuleFileIndexImpl(this, DirectoryIndex.getInstance(project2));
    }

    @Override
    public void init(@NotNull String path, @Nullable Runnable beforeComponentCreation) {
    }

    @Override
    public void moduleAdded() {
    }

    @Override
    public void projectOpened() {
    }

    @Override
    public void projectClosed() {
    }

    @Override
    public void rename(String newName) {
    }

    @Override
    public void clearScopesCache() {
        this.myModuleScopeProvider.clearCache();
    }

    public VirtualFile getModuleFile() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String getModuleFilePath() {
        return this.myPath;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getName() {
        return StringUtil.trimEnd((String)PathUtil.getFileName((String)this.myPath), (String)".iml");
    }

    public boolean isLoaded() {
        return true;
    }

    public void setOption(@NotNull String optionName, @NotNull String optionValue) {
        throw new UnsupportedOperationException();
    }

    public void clearOption(@NotNull String optionName) {
        throw new UnsupportedOperationException();
    }

    public String getOptionValue(@NotNull String optionName) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public GlobalSearchScope getModuleScope() {
        return this.myModuleScopeProvider.getModuleScope();
    }

    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        return this.myModuleScopeProvider.getModuleScope(includeTests);
    }

    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        return this.myModuleScopeProvider.getModuleWithLibrariesScope();
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        return this.myModuleScopeProvider.getModuleWithDependenciesScope();
    }

    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        return this.myModuleScopeProvider.getModuleContentScope();
    }

    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        return this.myModuleScopeProvider.getModuleContentWithDependenciesScope();
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        return this.myModuleScopeProvider.getModuleWithDependenciesAndLibrariesScope(includeTests);
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        return this.myModuleScopeProvider.getModuleWithDependentsScope();
    }

    @NotNull
    public GlobalSearchScope getModuleTestsWithDependentsScope() {
        return this.myModuleScopeProvider.getModuleTestsWithDependentsScope();
    }

    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        return this.myModuleScopeProvider.getModuleRuntimeScope(includeTests);
    }
}

