/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreFileTypeRegistry
extends FileTypeRegistry {
    private final Map<String, FileType> myExtensionsMap = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
    private final List<FileType> myAllFileTypes = new ArrayList<FileType>();

    public CoreFileTypeRegistry() {
        this.myAllFileTypes.add(UnknownFileType.INSTANCE);
    }

    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        return false;
    }

    public FileType[] getRegisteredFileTypes() {
        return this.myAllFileTypes.toArray(new FileType[this.myAllFileTypes.size()]);
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 instanceof LightVirtualFile && (fileType = ((LightVirtualFile)file2).getAssignedFileType()) != null) {
            return fileType;
        }
        return this.getFileTypeByFileName(file2.getName());
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull @NonNls String fileName) {
        String extension = FileUtilRt.getExtension((String)fileName);
        return this.getFileTypeByExtension(extension);
    }

    @NotNull
    public FileType getFileTypeByExtension(@NonNls @NotNull String extension) {
        FileType result = this.myExtensionsMap.get(extension);
        return result == null ? UnknownFileType.INSTANCE : result;
    }

    public void registerFileType(@NotNull FileType fileType, @NotNull @NonNls String extension) {
        this.myAllFileTypes.add(fileType);
        for (String ext : extension.split(";")) {
            this.myExtensionsMap.put(ext, fileType);
        }
    }

    @NotNull
    public FileType detectFileTypeFromContent(@NotNull VirtualFile file2) {
        return UnknownFileType.INSTANCE;
    }

    @Nullable
    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        for (FileType type : this.myAllFileTypes) {
            if (!type.getName().equals(fileTypeName)) continue;
            return type;
        }
        return null;
    }
}

