/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.core.CoreASTFactory;
import com.intellij.core.CoreEncodingRegistry;
import com.intellij.core.CoreFileTypeRegistry;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockApplicationEx;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.CoreCommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.impl.CoreVirtualFilePointerManager;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiReferenceServiceImpl;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistryImpl;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.psi.stubs.CoreStubTreeLoader;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.io.File;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;

public class CoreApplicationEnvironment {
    private final CoreFileTypeRegistry myFileTypeRegistry;
    protected final MockApplication myApplication;
    private final CoreLocalFileSystem myLocalFileSystem;
    protected final VirtualFileSystem myJarFileSystem;
    @NotNull
    private final Disposable myParentDisposable;

    public CoreApplicationEnvironment(@NotNull Disposable parentDisposable) {
        this.myParentDisposable = parentDisposable;
        this.myFileTypeRegistry = new CoreFileTypeRegistry();
        this.myApplication = this.createApplication(this.myParentDisposable);
        ApplicationManager.setApplication((Application)this.myApplication, (Getter)new StaticGetter((Object)this.myFileTypeRegistry), (Disposable)this.myParentDisposable);
        this.myLocalFileSystem = this.createLocalFileSystem();
        this.myJarFileSystem = this.createJarFileSystem();
        Extensions.registerAreaClass((String)"IDEA_PROJECT", null);
        MutablePicoContainer appContainer = this.myApplication.getPicoContainer();
        CoreApplicationEnvironment.registerComponentInstance(appContainer, FileDocumentManager.class, new MockFileDocumentManagerImpl(new Function<CharSequence, Document>(){

            public Document fun(CharSequence charSequence) {
                return new DocumentImpl(charSequence);
            }
        }, null));
        VirtualFileSystem[] fs = new VirtualFileSystem[]{this.myLocalFileSystem, this.myJarFileSystem};
        VirtualFileManagerImpl virtualFileManager = new VirtualFileManagerImpl(fs, this.myApplication.getMessageBus());
        CoreApplicationEnvironment.registerComponentInstance(appContainer, VirtualFileManager.class, virtualFileManager);
        this.registerApplicationService(EncodingManager.class, new CoreEncodingRegistry());
        this.registerApplicationService(VirtualFilePointerManager.class, this.createVirtualFilePointerManager());
        this.registerApplicationService(DefaultASTFactory.class, new CoreASTFactory());
        this.registerApplicationService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.registerApplicationService(ReferenceProvidersRegistry.class, new ReferenceProvidersRegistryImpl());
        this.registerApplicationService(StubTreeLoader.class, new CoreStubTreeLoader());
        this.registerApplicationService(PsiReferenceService.class, new PsiReferenceServiceImpl());
        this.registerApplicationService(MetaDataRegistrar.class, new MetaRegistry());
        this.registerApplicationService(ProgressManager.class, this.createProgressIndicatorProvider());
        this.registerApplicationService(JobLauncher.class, this.createJobLauncher());
        this.registerApplicationService(CodeFoldingSettings.class, new CodeFoldingSettings());
        this.registerApplicationService(CommandProcessor.class, new CoreCommandProcessor());
        this.myApplication.registerService(ApplicationInfo.class, ApplicationInfoImpl.class);
    }

    public <T> void registerApplicationService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        this.myApplication.registerService(serviceInterface, serviceImplementation);
    }

    @NotNull
    protected VirtualFilePointerManager createVirtualFilePointerManager() {
        return new CoreVirtualFilePointerManager();
    }

    @NotNull
    protected MockApplication createApplication(@NotNull Disposable parentDisposable) {
        return new MockApplicationEx(parentDisposable);
    }

    @NotNull
    protected JobLauncher createJobLauncher() {
        return new JobLauncher(){

            @Override
            public <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<T> things, ProgressIndicator progress, boolean runInReadAction, boolean failFastOnAcquireReadAction, @NotNull Processor<? super T> thingProcessor) {
                for (T thing : things) {
                    if (thingProcessor.process(thing)) continue;
                    return false;
                }
                return true;
            }

            @Override
            @NotNull
            public <T> AsyncFuture<Boolean> invokeConcurrentlyUnderProgressAsync(@NotNull List<T> things, ProgressIndicator progress, boolean failFastOnAcquireReadAction, @NotNull Processor<? super T> thingProcessor) {
                return AsyncUtil.wrapBoolean((boolean)this.invokeConcurrentlyUnderProgress(things, progress, failFastOnAcquireReadAction, thingProcessor));
            }

            @Override
            @NotNull
            public Job<Void> submitToJobThread(@NotNull Runnable action, Consumer<Future> onDoneCallback) {
                action.run();
                if (onDoneCallback != null) {
                    onDoneCallback.consume((Object)new Future(){

                        @Override
                        public boolean cancel(boolean mayInterruptIfRunning) {
                            return false;
                        }

                        @Override
                        public boolean isCancelled() {
                            return false;
                        }

                        @Override
                        public boolean isDone() {
                            return true;
                        }

                        public Object get() {
                            return null;
                        }

                        public Object get(long timeout, @NotNull TimeUnit unit) {
                            return null;
                        }
                    });
                }
                return Job.NULL_JOB;
            }
        };
    }

    @NotNull
    protected ProgressManager createProgressIndicatorProvider() {
        return new CoreProgressManager();
    }

    @NotNull
    protected VirtualFileSystem createJarFileSystem() {
        return new CoreJarFileSystem();
    }

    @NotNull
    protected CoreLocalFileSystem createLocalFileSystem() {
        return new CoreLocalFileSystem();
    }

    @NotNull
    public MockApplication getApplication() {
        return this.myApplication;
    }

    @NotNull
    public Disposable getParentDisposable() {
        return this.myParentDisposable;
    }

    public <T> void registerApplicationComponent(@NotNull Class<T> interfaceClass, @NotNull T implementation) {
        CoreApplicationEnvironment.registerComponentInstance(this.myApplication.getPicoContainer(), interfaceClass, implementation);
    }

    public void registerFileType(@NotNull FileType fileType, @NotNull String extension) {
        this.myFileTypeRegistry.registerFileType(fileType, extension);
    }

    public void registerParserDefinition(@NotNull ParserDefinition definition) {
        this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, definition.getFileNodeType().getLanguage(), (Object)definition);
    }

    public static <T> void registerComponentInstance(@NotNull MutablePicoContainer container, @NotNull Class<T> key, @NotNull T implementation) {
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
    }

    public <T> void addExplicitExtension(@NotNull LanguageExtension<T> instance, @NotNull Language language, @NotNull T object) {
        this.doAddExplicitExtension((KeyedExtensionCollector)instance, (Object)language, object);
    }

    public void registerParserDefinition(@NotNull Language language, @NotNull ParserDefinition parserDefinition) {
        this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, language, (Object)parserDefinition);
    }

    public <T> void addExplicitExtension(@NotNull FileTypeExtension<T> instance, @NotNull FileType fileType, @NotNull T object) {
        this.doAddExplicitExtension((KeyedExtensionCollector)instance, (Object)fileType, object);
    }

    private <T, U> void doAddExplicitExtension(final @NotNull KeyedExtensionCollector<T, U> instance, final @NotNull U key, final @NotNull T object) {
        instance.addExplicitExtension(key, object);
        Disposer.register((Disposable)this.myParentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                instance.removeExplicitExtension(key, object);
            }
        });
    }

    public <T> void addExplicitExtension(@NotNull ClassExtension<T> instance, @NotNull Class aClass, @NotNull T object) {
        this.doAddExplicitExtension((KeyedExtensionCollector)instance, (Object)aClass, object);
    }

    public <T> void addExtension(@NotNull ExtensionPointName<T> name, final @NotNull T extension) {
        final ExtensionPoint extensionPoint = Extensions.getRootArea().getExtensionPoint(name);
        extensionPoint.registerExtension(extension);
        Disposer.register((Disposable)this.myParentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                if (extensionPoint.hasExtension(extension)) {
                    extensionPoint.unregisterExtension(extension);
                }
            }
        });
    }

    public static <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        String name = extensionPointName.getName();
        CoreApplicationEnvironment.registerExtensionPoint(area, name, aClass);
    }

    public static <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull String name, @NotNull Class<? extends T> aClass) {
        if (!area.hasExtensionPoint(name)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || (aClass.getModifiers() & 0x400) != 0 ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            area.registerExtensionPoint(name, aClass.getName(), kind);
        }
    }

    public static <T> void registerApplicationExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), extensionPointName, aClass);
    }

    public static void registerExtensionPointAndExtensions(@NotNull File pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        PluginManagerCore.registerExtensionPointAndExtensions(pluginRoot, fileName, area);
    }

    @NotNull
    public CoreLocalFileSystem getLocalFileSystem() {
        return this.myLocalFileSystem;
    }

    @NotNull
    public VirtualFileSystem getJarFileSystem() {
        return this.myJarFileSystem;
    }
}

