/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.PsiCoreCommentImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.annotations.NotNull;

public class CoreASTFactory
extends ASTFactory
implements DefaultASTFactory {
    @Override
    @NotNull
    public LazyParseableElement createLazy(ILazyParseableElementType type, CharSequence text) {
        if (type instanceof IFileElementType) {
            return new FileElement((IElementType)type, text);
        }
        return new LazyParseableElement((IElementType)type, text);
    }

    @Override
    @NotNull
    public CompositeElement createComposite(IElementType type) {
        if (type instanceof IFileElementType) {
            return new FileElement(type, null);
        }
        return new CompositeElement(type);
    }

    @Override
    @NotNull
    public LeafElement createLeaf(@NotNull IElementType type, @NotNull CharSequence text) {
        Language lang = type.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null && parserDefinition.getCommentTokens().contains(type)) {
            return this.createComment(type, text);
        }
        return new LeafPsiElement(type, text);
    }

    @Override
    @NotNull
    public LeafElement createComment(@NotNull IElementType type, @NotNull CharSequence text) {
        return new PsiCoreCommentImpl(type, text);
    }
}

