/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ProjectFileStorageAnnotation;
import com.intellij.configurationStore.ProjectStateStorageManager;
import com.intellij.configurationStore.ProjectStoreBase;
import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.ConstantsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0012\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u0013H\u0014JH\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u00132\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u00182\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0014J\b\u0010\u001c\u001a\u00020\u0005H\u0004J\b\u0010\u001d\u001a\u00020\u000bH\u0016J9\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u0011H\u0002J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u000bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006,"}, d2={"Lcom/intellij/configurationStore/ProjectStoreImpl;", "Lcom/intellij/configurationStore/ProjectStoreBase;", "project", "Lcom/intellij/openapi/project/impl/ProjectImpl;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "(Lcom/intellij/openapi/project/impl/ProjectImpl;Lcom/intellij/openapi/components/PathMacroManager;)V", "isDirectoryBased", "", "()Z", "lastSavedProjectName", "", "storageManager", "Lcom/intellij/configurationStore/ProjectStateStorageManager;", "getStorageManager", "()Lcom/intellij/configurationStore/ProjectStateStorageManager;", "beforeSave", "", "readonlyFiles", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/components/StateStorage$SaveSession;", "Lcom/intellij/openapi/vfs/VirtualFile;", "doSave", "", "", "saveSessions", "prevErrors", "getPathMacroManagerForDefaults", "getProjectName", "getStorageSpecs", "", "Lcom/intellij/openapi/components/Storage;", "T", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "(Lcom/intellij/openapi/components/PersistentStateComponent;Lcom/intellij/openapi/components/State;Lcom/intellij/openapi/components/StateStorageOperation;)[Lcom/intellij/openapi/components/Storage;", "saveProjectName", "setPath", "filePath", "configuration-store-impl"})
class ProjectStoreImpl
extends ProjectStoreBase {
    private String lastSavedProjectName;
    @NotNull
    private final ProjectStateStorageManager storageManager;
    private final PathMacroManager pathMacroManager;

    @Override
    @NotNull
    protected final PathMacroManager getPathMacroManagerForDefaults() {
        return this.pathMacroManager;
    }

    @Override
    @NotNull
    public ProjectStateStorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public void setPath(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        this.setPath(filePath, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getProjectName() {
        int i;
        int endIndex$iv;
        if (this.isDirectoryBased()) {
            String baseDir = this.getProjectBasePath();
            Path nameFile = ProjectStoreImplKt.getNameFile(this);
            if (PathKt.exists(nameFile)) {
                try {
                    BufferedReader it$iv;
                    void $receiver$iv$iv;
                    InputStream inputStream = PathKt.inputStream(nameFile);
                    Object object = null;
                    boolean bl = true;
                    Object var6_14 = null;
                    if (var6_14 != null) {
                        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reader");
                    }
                    if (bl & true) {
                        object = Charsets.UTF_8;
                    }
                    Object $receiver$iv = new InputStreamReader(inputStream, (Charset)object);
                    object = $receiver$iv;
                    int $i$f$reader = 0;
                    boolean bl2 = true;
                    Object var7_20 = null;
                    if (var7_20 != null) {
                        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
                    }
                    if (bl2 & true) {
                        $i$f$reader = ConstantsKt.DEFAULT_BUFFER_SIZE;
                    }
                    object = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, $i$f$reader);
                    boolean closed$iv$iv = false;
                    try {
                        String string;
                        Object v0;
                        String $receiver$iv2;
                        block25: {
                            Sequence it;
                            it$iv = (BufferedReader)$receiver$iv$iv;
                            Sequence sequence = it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                            Iterator iterator = $receiver$iv2.iterator();
                            while (iterator.hasNext()) {
                                void $receiver$iv3;
                                Object element$iv = iterator.next();
                                String it2 = (String)element$iv;
                                CharSequence charSequence = it2;
                                if (!(!($receiver$iv3.length() == 0))) continue;
                                v0 = element$iv;
                                break block25;
                            }
                            v0 = null;
                        }
                        String string2 = v0;
                        if (string2 != null) {
                            $receiver$iv2 = string2;
                            String string3 = $receiver$iv2;
                            if (string3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                        } else {
                            string = null;
                        }
                        it$iv = string;
                    }
                    catch (Exception e$iv$iv) {
                        closed$iv$iv = true;
                        try {
                            $receiver$iv$iv.close();
                        }
                        catch (Exception closeException$iv$iv) {
                            // empty catch block
                        }
                        throw (Throwable)e$iv$iv;
                    }
                    finally {
                        if (!closed$iv$iv) {
                            $receiver$iv$iv.close();
                        }
                    }
                    String string = (String)((Object)it$iv);
                    if (string != null) {
                        String it;
                        $receiver$iv = string;
                        this.lastSavedProjectName = it = (String)$receiver$iv;
                        return it;
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            return StringsKt.replace$default((String)PathUtilRt.getFileName((String)baseDir), (String)":", (String)"", (boolean)false, (int)4, null);
        }
        String temp = PathUtilRt.getFileName((String)this.getProjectFilePath());
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(temp);
        if (fileType instanceof ProjectFileType) {
            void startIndex$iv2;
            void $receiver$iv;
            String ignored = temp;
            boolean it = false;
            int $i$a$2 = temp.length() - ((ProjectFileType)fileType).getDefaultExtension().length() - 1;
            void v5 = $receiver$iv;
            if (v5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)v5).substring((int)startIndex$iv2, endIndex$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            temp = string;
        }
        if ((i = StringsKt.lastIndexOf$default((CharSequence)temp, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null)) >= 0) {
            void endIndex$iv2;
            void startIndex$iv;
            void $receiver$iv;
            String startIndex$iv2 = temp;
            endIndex$iv = i + 1;
            int $i$f$substring = temp.length() - i + 1;
            void v7 = $receiver$iv;
            if (v7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)v7).substring((int)startIndex$iv, (int)endIndex$iv2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            temp = string;
        }
        String string = temp;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"temp");
        return string;
    }

    private final boolean isDirectoryBased() {
        return Intrinsics.areEqual((Object)this.getScheme(), (Object)StorageScheme.DIRECTORY_BASED);
    }

    private final void saveProjectName() {
        if (!this.isDirectoryBased()) {
            return;
        }
        String currentProjectName = this.getProject().getName();
        if (Intrinsics.areEqual((Object)this.lastSavedProjectName, (Object)currentProjectName)) {
            return;
        }
        this.lastSavedProjectName = currentProjectName;
        String basePath = this.getProjectBasePath();
        if (Intrinsics.areEqual((Object)currentProjectName, (Object)PathUtilRt.getFileName((String)basePath))) {
            PathKt.delete(ProjectStoreImplKt.getNameFile(this));
        } else {
            Path baseDir = Paths.get(basePath, new String[0]);
            if (PathKt.isDirectory(baseDir)) {
                String string = currentProjectName;
                Charset charset = null;
                boolean bl = true;
                Object var7_7 = null;
                Path path = ProjectStoreImplKt.getNameFile(this);
                if (var7_7 != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
                }
                if (bl & true) {
                    charset = Charsets.UTF_8;
                }
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                PathKt.write$default(path, byArray2, 0, 0, 6, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected List<Throwable> doSave(@NotNull List<? extends StateStorage.SaveSession> saveSessions, @NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles, @Nullable List<Throwable> prevErrors) {
        ReadonlyStatusHandler.OperationStatus status;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(saveSessions, (String)"saveSessions");
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
        try {
            this.saveProjectName();
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Unable to store project name", e);
        }
        List<Throwable> errors = prevErrors;
        this.beforeSave(readonlyFiles);
        super.doSave(saveSessions, readonlyFiles, errors);
        ProjectManagerImpl.UnableToSaveProjectNotification[] notifications = (ProjectManagerImpl.UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectManagerImpl.UnableToSaveProjectNotification.class, (Project)this.getProject());
        if (readonlyFiles.isEmpty()) {
            for (int i = 0; i < notifications.length; ++i) {
                ProjectManagerImpl.UnableToSaveProjectNotification notification = notifications[i];
                notification.expire();
            }
            return errors;
        }
        Object[] notification = (Object[])notifications;
        if (!(((void)$receiver$iv).length == 0)) {
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        AccessToken token = ReadAction.start();
        try {
            VirtualFile[] virtualFileArray = ProjectStoreImplKt.access$getFilesList(readonlyFiles);
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)this.getProject()).ensureFilesWritable(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)operationStatus, (String)"ReadonlyStatusHandler.ge\u2026FilesList(readonlyFiles))");
            status = operationStatus;
        }
        finally {
            token.finish();
        }
        if (status.hasReadonlyFiles()) {
            Project project2 = this.getProject();
            VirtualFile[] virtualFileArray = status.getReadonlyFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"status.readonlyFiles");
            ProjectStoreImplKt.access$dropUnableToSaveProjectNotification(project2, virtualFileArray);
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        ArrayList oldList = new ArrayList(readonlyFiles);
        readonlyFiles.clear();
        for (Pair entry : oldList) {
            StateStorage.SaveSession saveSession = (StateStorage.SaveSession)entry.first;
            Intrinsics.checkExpressionValueIsNotNull((Object)saveSession, (String)"entry.first");
            errors = ComponentStoreImplKt.executeSave(saveSession, readonlyFiles, errors);
        }
        if (errors != null) {
            CompoundRuntimeException.throwIfNotEmpty(errors);
        }
        if (!readonlyFiles.isEmpty()) {
            ProjectStoreImplKt.access$dropUnableToSaveProjectNotification(this.getProject(), ProjectStoreImplKt.access$getFilesList(readonlyFiles));
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        return errors;
    }

    protected void beforeSave(@NotNull List<? extends Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected <T> Storage[] getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        void $receiver$iv;
        Collection elements$iv;
        ProjectFileStorageAnnotation[] storage2;
        List result;
        ProjectFileStorageAnnotation[] $receiver$iv2;
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Storage[] storages = stateSpec.storages();
        Object[] objectArray = storages;
        if ($receiver$iv2.length == 0) {
            void elements$iv2;
            $receiver$iv2 = new ProjectFileStorageAnnotation[]{ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION()};
            return (Storage[])((Object[])elements$iv2);
        }
        if (this.isDirectoryBased()) {
            void $receiver$iv3;
            Collection elements$iv3;
            ProjectFileStorageAnnotation[] storage3;
            result = null;
            for (int i = 0; i < storages.length; ++i) {
                Unit unit;
                storage3 = storages[i];
                if (Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storage3), (Object)ProjectStoreImplKt.PROJECT_FILE) ^ true) {
                    if (result == null) {
                        result = (List)new SmartList();
                    }
                    result.add(storage3);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = Unit.INSTANCE;
            }
            if (UtilKt.isNullOrEmpty(result)) {
                storage3 = new ProjectFileStorageAnnotation[]{ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION()};
                return (Storage[])((Object[])elements$iv3);
            }
            List list = result;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            CollectionsKt.sortWith((List)list, ComponentStoreImplKt.getDeprecatedComparator());
            result.add(ProjectStoreImplKt.getDEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION());
            elements$iv3 = result;
            void v2 = $receiver$iv3;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v2;
            Storage[] storageArray = thisCollection$iv.toArray(new Storage[thisCollection$iv.size()]);
            if (storageArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return (Storage[])((Object[])storageArray);
        }
        result = null;
        boolean hasOnlyDeprecatedStorages = true;
        for (int $i$f$toTypedArray = 0; $i$f$toTypedArray < storages.length; ++$i$f$toTypedArray) {
            Unit unit;
            storage2 = storages[$i$f$toTypedArray];
            if (Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storage2), (Object)ProjectStoreImplKt.PROJECT_FILE) || Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storage2), (Object)"$WORKSPACE_FILE$")) {
                if (result == null) {
                    result = (List)new SmartList();
                }
                result.add(storage2);
                if (!storage2.deprecated()) {
                    hasOnlyDeprecatedStorages = false;
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = Unit.INSTANCE;
                continue;
            }
            unit = Unit.INSTANCE;
        }
        if (UtilKt.isNullOrEmpty(result)) {
            storage2 = new ProjectFileStorageAnnotation[]{ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION()};
            return (Storage[])((Object[])elements$iv);
        }
        if (hasOnlyDeprecatedStorages) {
            List list = result;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.add(ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION());
        }
        List list = result;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        CollectionsKt.sortWith((List)list, ComponentStoreImplKt.getDeprecatedComparator());
        elements$iv = result;
        void v7 = $receiver$iv;
        if (v7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = (Collection)v7;
        Storage[] storageArray = thisCollection$iv.toArray(new Storage[thisCollection$iv.size()]);
        if (storageArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (Storage[])((Object[])storageArray);
    }

    public ProjectStoreImpl(@NotNull ProjectImpl project2, @NotNull PathMacroManager pathMacroManager) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)pathMacroManager, (String)"pathMacroManager");
        super(project2);
        this.pathMacroManager = pathMacroManager;
        boolean value$iv = !project2.isDefault();
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv$iv = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = this.pathMacroManager.createTrackingSubstitutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)trackingPathMacroSubstitutor, (String)"pathMacroManager.createTrackingSubstitutor()");
        this.storageManager = new ProjectStateStorageManager(trackingPathMacroSubstitutor, project2);
    }
}

