/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.impl.MessagesContainer;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AutomakeCompileContext
extends UserDataHolderBase
implements CompileContext {
    private final Project myProject;
    private final ProjectCompileScope myScope;
    private final MessagesContainer myMessages;
    private final EmptyProgressIndicator myIndicator;
    private final boolean myAnnotationProcessingEnabled;

    public AutomakeCompileContext(Project project2) {
        this.myProject = project2;
        this.myScope = new ProjectCompileScope(project2);
        this.myMessages = new MessagesContainer(project2);
        this.myIndicator = new EmptyProgressIndicator();
        this.myAnnotationProcessingEnabled = CompilerConfiguration.getInstance((Project)project2).isAnnotationProcessorsEnabled();
    }

    public Project getProject() {
        return this.myProject;
    }

    public CompileScope getCompileScope() {
        return this.getProjectCompileScope();
    }

    public CompileScope getProjectCompileScope() {
        return this.myScope;
    }

    public boolean isMake() {
        return true;
    }

    public boolean isAutomake() {
        return true;
    }

    public void addMessage(CompilerMessageCategory category, String message, @Nullable String url, int lineNum, int columnNum) {
        this.addMessage(category, message, url, lineNum, columnNum, null);
    }

    public void addMessage(CompilerMessageCategory category, String message, @Nullable String url, int lineNum, int columnNum, Navigatable navigatable) {
        this.createAndAddMessage(category, message, url, lineNum, columnNum, navigatable);
    }

    public CompilerMessage[] getMessages(CompilerMessageCategory category) {
        return this.myMessages.getMessages(category).toArray(CompilerMessage.EMPTY_ARRAY);
    }

    @Nullable
    public CompilerMessage createAndAddMessage(CompilerMessageCategory category, String message, @Nullable String url, int lineNum, int columnNum, Navigatable navigatable) {
        return this.myMessages.addMessage(category, message, url, lineNum, columnNum, navigatable);
    }

    public int getMessageCount(CompilerMessageCategory category) {
        return this.myMessages.getMessageCount(category);
    }

    @NotNull
    public ProgressIndicator getProgressIndicator() {
        return this.myIndicator;
    }

    public void requestRebuildNextTime(String message) {
    }

    public boolean isRebuildRequested() {
        return false;
    }

    @Nullable
    public String getRebuildReason() {
        return null;
    }

    public Module getModuleByFile(VirtualFile file2) {
        return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file2);
    }

    public VirtualFile getModuleOutputDirectory(Module module2) {
        return CompilerPaths.getModuleOutputDirectory((Module)module2, (boolean)false);
    }

    public VirtualFile getModuleOutputDirectoryForTests(Module module2) {
        return CompilerPaths.getModuleOutputDirectory((Module)module2, (boolean)true);
    }

    public boolean isRebuild() {
        return false;
    }

    public boolean isAnnotationProcessorsEnabled() {
        return this.myAnnotationProcessingEnabled;
    }
}

