/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.Semaphore;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileStepBeforeRun
extends BeforeRunTaskProvider<MakeBeforeRunTask> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.options.CompileStepBeforeRun");
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Make");
    public static final Key<RunConfiguration> RUN_CONFIGURATION = Key.create((String)"RUN_CONFIGURATION");
    public static final Key<String> RUN_CONFIGURATION_TYPE_ID = Key.create((String)"RUN_CONFIGURATION_TYPE_ID");
    @NonNls
    protected static final String MAKE_PROJECT_ON_RUN_KEY = "makeProjectOnRun";
    private final Project myProject;

    public CompileStepBeforeRun(@NotNull Project project2) {
        this.myProject = project2;
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
    }

    public String getDescription(MakeBeforeRunTask task) {
        return ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.Actions.Compile;
    }

    public Icon getTaskIcon(MakeBeforeRunTask task) {
        return AllIcons.Actions.Compile;
    }

    @Nullable
    public MakeBeforeRunTask createTask(RunConfiguration configuration) {
        MakeBeforeRunTask task = null;
        if (CompileStepBeforeRun.shouldCreateTask(configuration)) {
            task = new MakeBeforeRunTask();
            if (configuration instanceof RunConfigurationBase) {
                task.setEnabled(((RunConfigurationBase)configuration).isCompileBeforeLaunchAddedByDefault());
            }
        }
        return task;
    }

    static boolean shouldCreateTask(RunConfiguration configuration) {
        return !(configuration instanceof RemoteConfiguration) && configuration instanceof RunProfileWithCompileBeforeLaunchOption;
    }

    public boolean configureTask(RunConfiguration runConfiguration, MakeBeforeRunTask task) {
        return false;
    }

    public boolean canExecuteTask(RunConfiguration configuration, MakeBeforeRunTask task) {
        return true;
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, MakeBeforeRunTask task) {
        return CompileStepBeforeRun.doMake(this.myProject, configuration, env, false);
    }

    static boolean doMake(Project myProject, RunConfiguration configuration, ExecutionEnvironment env, boolean ignoreErrors) {
        return CompileStepBeforeRun.doMake(myProject, configuration, env, ignoreErrors, Boolean.getBoolean(MAKE_PROJECT_ON_RUN_KEY));
    }

    static boolean doMake(final Project myProject, final RunConfiguration configuration, final ExecutionEnvironment env, final boolean ignoreErrors, final boolean forceMakeProject) {
        if (!(configuration instanceof RunProfileWithCompileBeforeLaunchOption)) {
            return true;
        }
        if (configuration instanceof RunConfigurationBase && ((RunConfigurationBase)configuration).excludeCompileBeforeLaunchOption()) {
            return true;
        }
        final RunProfileWithCompileBeforeLaunchOption runConfiguration = (RunProfileWithCompileBeforeLaunchOption)configuration;
        final Ref result = new Ref((Object)Boolean.FALSE);
        try {
            final Semaphore done2 = new Semaphore();
            done2.down();
            final CompileStatusNotification callback = new CompileStatusNotification(){

                public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    if ((errors == 0 || ignoreErrors) && !aborted) {
                        result.set((Object)Boolean.TRUE);
                    }
                    done2.up();
                }
            };
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    CompileScope scope;
                    CompilerManager compilerManager = CompilerManager.getInstance((Project)myProject);
                    if (forceMakeProject) {
                        scope = compilerManager.createProjectCompileScope(myProject);
                    } else {
                        Module[] modules = runConfiguration.getModules();
                        if (modules.length > 0) {
                            for (Module module2 : modules) {
                                if (module2 != null) continue;
                                LOG.error("RunConfiguration should not return null modules. Configuration=" + runConfiguration.getName() + "; class=" + runConfiguration.getClass().getName());
                            }
                            scope = compilerManager.createModulesCompileScope(modules, true, true);
                        } else {
                            scope = compilerManager.createProjectCompileScope(myProject);
                        }
                    }
                    if (!myProject.isDisposed()) {
                        scope.putUserData(RUN_CONFIGURATION, (Object)configuration);
                        scope.putUserData(RUN_CONFIGURATION_TYPE_ID, (Object)configuration.getType().getId());
                        ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)scope, ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.get((UserDataHolder)env));
                        compilerManager.make(scope, callback);
                    } else {
                        done2.up();
                    }
                }
            });
            done2.waitFor();
        }
        catch (Exception e) {
            return false;
        }
        return (Boolean)result.get();
    }

    public boolean isConfigurable() {
        return false;
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(CompileContext context) {
        return CompileStepBeforeRun.getRunConfiguration(context.getCompileScope());
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(CompileScope compileScope) {
        return (RunConfiguration)compileScope.getUserData(RUN_CONFIGURATION);
    }

    public static class MakeBeforeRunTask
    extends BeforeRunTask<MakeBeforeRunTask> {
        public MakeBeforeRunTask() {
            super(ID);
            this.setEnabled(true);
        }
    }
}

