/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.eclipse;

import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfigurable;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfiguration;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.impl.java.EclipseCompilerTool;

public class EclipseCompiler
implements BackendCompiler {
    private final Project myProject;

    public EclipseCompiler(Project project2) {
        this.myProject = project2;
    }

    public static boolean isInitialized() {
        return EclipseCompilerTool.findEcjJarFile() != null;
    }

    @Override
    @NotNull
    public String getId() {
        return "Eclipse";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return CompilerBundle.message((String)"compiler.eclipse.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Configurable createConfigurable() {
        return new EclipseCompilerConfigurable(EclipseCompilerConfiguration.getOptions(this.myProject, EclipseCompilerConfiguration.class));
    }

    @Override
    @NotNull
    public Set<FileType> getCompilableFileTypes() {
        return Collections.singleton(StdFileTypes.JAVA);
    }
}

