/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.FileIndexCompileScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleCompileScope
extends FileIndexCompileScope {
    private final Project myProject;
    private final Set<Module> myScopeModules;
    private final Module[] myModules;
    private final Map<Module, String[]> myContentUrlsCache = new HashMap<Module, String[]>();

    public ModuleCompileScope(Module module2, boolean includeDependentModules) {
        this(module2.getProject(), Collections.singleton(module2), includeDependentModules, false);
    }

    public ModuleCompileScope(Project project2, Module[] modules, boolean includeDependentModules) {
        this(project2, modules, includeDependentModules, false);
    }

    public ModuleCompileScope(Project project2, Module[] modules, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        this(project2, Arrays.asList(modules), includeDependentModules, includeRuntimeDependencies);
    }

    private ModuleCompileScope(Project project2, Collection<Module> modules, boolean includeDependentModules, boolean includeRuntimeDeps) {
        this.myProject = project2;
        this.myScopeModules = new HashSet<Module>();
        for (Module module2 : modules) {
            if (module2 == null) continue;
            if (includeDependentModules) {
                OrderEnumerator enumerator = ModuleRootManager.getInstance((Module)module2).orderEntries().recursively();
                if (!includeRuntimeDeps) {
                    enumerator = enumerator.compileOnly();
                }
                enumerator.forEachModule((Processor)new CommonProcessors.CollectProcessor(this.myScopeModules));
                continue;
            }
            this.myScopeModules.add(module2);
        }
        this.myModules = ModuleManager.getInstance((Project)this.myProject).getModules();
    }

    @NotNull
    public Module[] getAffectedModules() {
        return this.myScopeModules.toArray(new Module[this.myScopeModules.size()]);
    }

    @Override
    protected FileIndex[] getFileIndices() {
        FileIndex[] indices = new FileIndex[this.myScopeModules.size()];
        int idx = 0;
        for (Module module2 : this.myScopeModules) {
            indices[idx++] = ModuleRootManager.getInstance((Module)module2).getFileIndex();
        }
        return indices;
    }

    public boolean belongs(String url) {
        if (this.myScopeModules.isEmpty()) {
            return false;
        }
        Module candidateModule = null;
        int maxUrlLength = 0;
        final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (Module module2 : this.myModules) {
            String[] contentRootUrls;
            for (final String contentRootUrl : contentRootUrls = this.getModuleContentUrls(module2)) {
                if (contentRootUrl.length() < maxUrlLength || !ModuleCompileScope.isUrlUnderRoot(url, contentRootUrl)) continue;
                if (contentRootUrl.length() == maxUrlLength) {
                    if (candidateModule == null) {
                        candidateModule = module2;
                        continue;
                    }
                    if (candidateModule.equals(module2)) continue;
                    candidateModule = (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

                        public Module compute() {
                            VirtualFile contentRootFile = VirtualFileManager.getInstance().findFileByUrl(contentRootUrl);
                            if (contentRootFile != null) {
                                return projectFileIndex.getModuleForFile(contentRootFile);
                            }
                            return null;
                        }
                    });
                    continue;
                }
                maxUrlLength = contentRootUrl.length();
                candidateModule = module2;
            }
        }
        if (candidateModule != null && this.myScopeModules.contains(candidateModule)) {
            String[] sourceRootUrls;
            String[] excludeRootUrls;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(candidateModule);
            for (String excludeRootUrl : excludeRootUrls = moduleRootManager.getExcludeRootUrls()) {
                if (!ModuleCompileScope.isUrlUnderRoot(url, excludeRootUrl)) continue;
                return false;
            }
            for (String sourceRootUrl : sourceRootUrls = moduleRootManager.getSourceRootUrls()) {
                if (!ModuleCompileScope.isUrlUnderRoot(url, sourceRootUrl)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUrlUnderRoot(String url, String root) {
        return url.length() > root.length() && url.charAt(root.length()) == '/' && FileUtil.startsWith((String)url, (String)root);
    }

    private String[] getModuleContentUrls(Module module2) {
        String[] contentRootUrls = this.myContentUrlsCache.get(module2);
        if (contentRootUrls == null) {
            contentRootUrls = ModuleRootManager.getInstance((Module)module2).getContentRootUrls();
            this.myContentUrlsCache.put(module2, contentRootUrls);
        }
        return contentRootUrls;
    }
}

