/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.impl;

import com.intellij.compiler.classFilesIndex.api.index.ClassFilesIndexFeaturesHolder;
import com.intellij.compiler.classFilesIndex.api.index.ClassFilesIndexReaderBase;
import com.intellij.compiler.classFilesIndex.impl.MethodIncompleteSignature;
import com.intellij.compiler.classFilesIndex.impl.UsageIndexValue;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.Collection;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.classFilesIndex.TObjectIntHashMapExternalizer;
import org.jetbrains.jps.classFilesIndex.indexer.impl.EnumeratedMethodIncompleteSignature;

public class MethodsUsageIndexReader
extends ClassFilesIndexReaderBase<Integer, TObjectIntHashMap<EnumeratedMethodIncompleteSignature>> {
    public static MethodsUsageIndexReader getInstance(Project project2) {
        MethodsUsageIndexReader instance = ClassFilesIndexFeaturesHolder.getInstance(project2).getAvailableIndexReader(MethodsUsageIndexReader.class);
        if (instance == null) {
            throw new RuntimeException("couldn't get instance");
        }
        return instance;
    }

    public MethodsUsageIndexReader(Project project2, String canonicalIndexName, int version) {
        super(EnumeratorIntegerDescriptor.INSTANCE, new TObjectIntHashMapExternalizer(EnumeratedMethodIncompleteSignature.createDataExternalizer()), canonicalIndexName, version, project2);
    }

    @NotNull
    public TreeSet<UsageIndexValue> getMethods(final String key) {
        assert (this.myIndex != null);
        assert (this.myMappings != null);
        Collection unReducedValues = this.myIndex.getData(this.myMappings.getName(key.replace('.', '/')));
        final TObjectIntHashMap rawValues = new TObjectIntHashMap();
        for (TObjectIntHashMap unReducedValue : unReducedValues) {
            unReducedValue.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<EnumeratedMethodIncompleteSignature>(){

                public boolean execute(EnumeratedMethodIncompleteSignature sign, int occurrences) {
                    MethodIncompleteSignature denumerated = MethodIncompleteSignature.denumerated(sign, key, MethodsUsageIndexReader.this.myMappings);
                    if (!rawValues.adjustValue((Object)denumerated, occurrences)) {
                        rawValues.put((Object)denumerated, occurrences);
                    }
                    return true;
                }
            });
        }
        final TreeSet<UsageIndexValue> values = new TreeSet<UsageIndexValue>();
        rawValues.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<MethodIncompleteSignature>(){

            public boolean execute(MethodIncompleteSignature sign, int occurrences) {
                values.add(new UsageIndexValue(sign, occurrences));
                return true;
            }
        });
        return values;
    }
}

