/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.classFilesIndex.AsmUtil;
import org.jetbrains.jps.classFilesIndex.indexer.impl.EnumeratedMethodIncompleteSignature;

public class MethodIncompleteSignature {
    public static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    @NotNull
    private final String myOwner;
    @NotNull
    private final String myReturnType;
    @NotNull
    private final String myName;
    private final boolean myStatic;

    private MethodIncompleteSignature(@NotNull String owner, @NotNull String returnType, @NotNull String name, boolean aStatic) {
        this.myOwner = owner;
        this.myReturnType = returnType;
        this.myName = name;
        this.myStatic = aStatic;
    }

    public static MethodIncompleteSignature denumerated(EnumeratedMethodIncompleteSignature sign, String returnType, Mappings mappings) {
        return new MethodIncompleteSignature(AsmUtil.getQualifiedClassName((String)mappings.valueOf(sign.getOwner())), returnType, mappings.valueOf(sign.getName()), sign.isStatic());
    }

    @NotNull
    public String getOwner() {
        return this.myOwner;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getReturnType() {
        return this.myReturnType;
    }

    public boolean isStatic() {
        return this.myStatic;
    }

    public String toString() {
        return "MethodIncompleteSignature{myOwner='" + this.myOwner + '\'' + ", myReturnType='" + this.myReturnType + '\'' + ", myName='" + this.myName + '\'' + ", myStatic=" + this.myStatic + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MethodIncompleteSignature)) {
            return false;
        }
        MethodIncompleteSignature that = (MethodIncompleteSignature)o;
        if (this.myStatic != that.myStatic) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (!this.myOwner.equals(that.myOwner)) {
            return false;
        }
        return this.myReturnType.equals(that.myReturnType);
    }

    public int hashCode() {
        int result = this.myOwner.hashCode();
        result = 31 * result + this.myReturnType.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + (this.myStatic ? 1 : 0);
        return result;
    }
}

