/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch;

import org.jetbrains.annotations.NotNull;

public class ChainRelevance
implements Comparable<ChainRelevance> {
    public static final ChainRelevance LOWEST = new ChainRelevance(Integer.MAX_VALUE, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, false, false, 0);
    private final int myChainSize;
    private final int myLastMethodOccurrences;
    private final int myUnreachableParametersCount;
    private final int myNotMatchedStringVars;
    private final boolean myHasCallingVariableInContext;
    private final boolean myFirstMethodStatic;
    private final int myParametersInContext;

    public ChainRelevance(int chainSize, int lastMethodOccurrences, int unreachableParametersCount, int notMatchedStringVars, boolean hasCallingVariableInContext, boolean firstMethodStatic, int parametersInContext) {
        this.myChainSize = chainSize;
        this.myLastMethodOccurrences = lastMethodOccurrences;
        this.myUnreachableParametersCount = unreachableParametersCount;
        this.myNotMatchedStringVars = notMatchedStringVars;
        this.myHasCallingVariableInContext = hasCallingVariableInContext;
        this.myFirstMethodStatic = firstMethodStatic;
        this.myParametersInContext = parametersInContext;
    }

    public int getChainSize() {
        return this.myChainSize;
    }

    public int getLastMethodOccurrences() {
        return this.myLastMethodOccurrences;
    }

    public int getUnreachableParametersCount() {
        return this.myUnreachableParametersCount;
    }

    public int getNotMatchedStringVars() {
        return this.myNotMatchedStringVars;
    }

    @Override
    public int compareTo(@NotNull ChainRelevance that) {
        if (this.myHasCallingVariableInContext && !that.myHasCallingVariableInContext) {
            return 1;
        }
        if (that.myHasCallingVariableInContext && !this.myHasCallingVariableInContext) {
            return -1;
        }
        if (this.myFirstMethodStatic && !that.myFirstMethodStatic) {
            return -1;
        }
        if (that.myFirstMethodStatic && !this.myFirstMethodStatic) {
            return 1;
        }
        if (this.myParametersInContext > that.myParametersInContext) {
            return 1;
        }
        if (this.myParametersInContext <= that.myParametersInContext) {
            return -1;
        }
        int sub = this.myLastMethodOccurrences - that.myLastMethodOccurrences;
        if (sub != 0) {
            return sub;
        }
        sub = this.myUnreachableParametersCount - that.myUnreachableParametersCount;
        if (sub != 0) {
            return -sub;
        }
        return 0;
    }

    public String toString() {
        return (this.myFirstMethodStatic ? "1" : "0") + (this.myHasCallingVariableInContext ? "1" : "0") + "_" + this.myLastMethodOccurrences + "_" + this.myUnreachableParametersCount;
    }
}

