/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.api.index;

import com.intellij.compiler.classFilesIndex.api.index.ClassFilesIndexConfigure;
import com.intellij.compiler.classFilesIndex.api.index.ClassFilesIndexFeaturesHolder;
import com.intellij.compiler.classFilesIndex.api.index.ConfigureVisitor;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClassFilesIndexerBuilderParametersProvider
extends BuildProcessParametersProvider {
    private final ClassFilesIndexFeaturesHolder myIndicesHolder;

    protected ClassFilesIndexerBuilderParametersProvider(ClassFilesIndexFeaturesHolder indicesHolder) {
        this.myIndicesHolder = indicesHolder;
    }

    @Override
    @NotNull
    public List<String> getVMArguments() {
        final ArrayList args = new ArrayList();
        this.myIndicesHolder.visitConfigures(new ConfigureVisitor(){

            @Override
            public void visit(ClassFilesIndexConfigure<?, ?> configure, boolean isAvailable) {
                String className = configure.getIndexerBuilderClass().getCanonicalName();
                args.add(className);
                if (!isAvailable) {
                    configure.prepareToIndexing(ClassFilesIndexerBuilderParametersProvider.this.myIndicesHolder.getProject());
                }
            }
        });
        return args.size() != 0 ? Collections.singletonList("-Dintellij.compiler.output.index=" + StringUtil.join(args, (String)";")) : Collections.emptyList();
    }
}

