/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.api.index;

import com.intellij.compiler.classFilesIndex.api.index.ClassFilesIndexConfigure;
import com.intellij.compiler.classFilesIndex.impl.MethodsUsageIndexConfigure;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public enum ClassFilesIndexFeature {
    METHOD_CHAINS_COMPLETION("completion.enable.relevant.method.chain.suggestions", MethodsUsageIndexConfigure.INSTANCE);

    @NotNull
    private final String myKey;
    @NotNull
    private final Collection<? extends ClassFilesIndexConfigure> myRequiredIndicesConfigures;

    private ClassFilesIndexFeature(String key, Collection<? extends ClassFilesIndexConfigure> requiredIndicesConfigures) {
        this.myKey = key;
        this.myRequiredIndicesConfigures = requiredIndicesConfigures;
    }

    private ClassFilesIndexFeature(String key, ClassFilesIndexConfigure requiredConfigure) {
        this(key, Collections.singleton(requiredConfigure));
    }

    public RegistryValue getRegistryValue() {
        return Registry.get((String)this.myKey);
    }

    @NotNull
    public String getKey() {
        return this.myKey;
    }

    public boolean isEnabled() {
        return Registry.is((String)this.myKey);
    }

    public void enable() {
        this.getRegistryValue().setValue(true);
    }

    public void disable() {
        this.getRegistryValue().setValue(false);
    }

    @NotNull
    public Collection<? extends ClassFilesIndexConfigure> getRequiredIndicesConfigures() {
        return this.myRequiredIndicesConfigures;
    }
}

