/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.artifacts;

import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.Copy;
import com.intellij.compiler.ant.taskdefs.FileSet;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.compiler.ant.taskdefs.Unzip;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import org.jetbrains.annotations.NotNull;

public class DirectoryAntCopyInstructionCreator
implements AntCopyInstructionCreator {
    private final String myOutputDirectory;

    public DirectoryAntCopyInstructionCreator(String outputDirectory) {
        this.myOutputDirectory = outputDirectory;
    }

    public String getOutputDirectory() {
        return this.myOutputDirectory;
    }

    @NotNull
    public Tag createDirectoryContentCopyInstruction(@NotNull String dirPath) {
        Copy copy = new Copy(this.myOutputDirectory);
        copy.add((Generator)new FileSet(dirPath));
        return copy;
    }

    @NotNull
    public Tag createFileCopyInstruction(@NotNull String filePath, String outputFileName) {
        return new Copy(filePath, this.myOutputDirectory + "/" + outputFileName);
    }

    @NotNull
    public AntCopyInstructionCreator subFolder(@NotNull String directoryName) {
        return new DirectoryAntCopyInstructionCreator(this.myOutputDirectory + "/" + directoryName);
    }

    public Generator createSubFolderCommand(@NotNull String directoryName) {
        return new Mkdir(this.myOutputDirectory + "/" + directoryName);
    }

    @NotNull
    public Generator createExtractedDirectoryInstruction(@NotNull String jarPath) {
        return new Unzip(jarPath, this.myOutputDirectory);
    }
}

