/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.artifacts;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ArtifactAntGenerationContextImpl
implements ArtifactAntGenerationContext {
    @NonNls
    public static final String ARTIFACTS_TEMP_DIR_PROPERTY = "artifacts.temp.dir";
    private final Map<Artifact, String> myArtifact2Target = new THashMap();
    private final List<Generator> myBeforeBuildGenerators = new ArrayList<Generator>();
    private final List<Generator> myAfterBuildGenerators = new ArrayList<Generator>();
    private final Set<String> myTempFileNames = new THashSet();
    private final Set<String> myCreatedTempSubdirs = new THashSet();
    private final Set<String> myProperties = new LinkedHashSet<String>();
    private final Project myProject;
    private final GenerationOptions myGenerationOptions;
    private final List<Generator> myBeforeCurrentArtifact = new ArrayList<Generator>();
    private final Set<Artifact> myArtifactsToClean = new THashSet();

    public ArtifactAntGenerationContextImpl(Project project2, GenerationOptions generationOptions, List<Artifact> allArtifacts) {
        this.myProject = project2;
        this.myGenerationOptions = generationOptions;
        for (Artifact artifact : allArtifacts) {
            if (!ArtifactUtil.shouldClearArtifactOutputBeforeRebuild(artifact)) continue;
            this.myArtifactsToClean.add(artifact);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public GenerationOptions getGenerationOptions() {
        return this.myGenerationOptions;
    }

    public String getConfiguredArtifactOutputProperty(@NotNull Artifact artifact) {
        return "artifact.output." + BuildProperties.convertName((String)artifact.getName());
    }

    public String getArtifactOutputProperty(@NotNull Artifact artifact) {
        if (this.shouldBuildIntoTempDirectory(artifact)) {
            return "artifact.temp.output." + BuildProperties.convertName((String)artifact.getName());
        }
        return this.getConfiguredArtifactOutputProperty(artifact);
    }

    public boolean shouldBuildIntoTempDirectory(@NotNull Artifact artifact) {
        return !this.myArtifactsToClean.contains(artifact);
    }

    public String getCleanTargetName(@NotNull Artifact artifact) {
        return "clean.artifact." + BuildProperties.convertName((String)artifact.getName());
    }

    public String getTargetName(@NotNull Artifact artifact) {
        String target = this.myArtifact2Target.get(artifact);
        if (target == null) {
            target = ArtifactAntGenerationContextImpl.generateTargetName(artifact.getName());
            this.myArtifact2Target.put(artifact, target);
        }
        return target;
    }

    private static String generateTargetName(String artifactName) {
        return "artifact." + BuildProperties.convertName((String)artifactName);
    }

    public String getSubstitutedPath(String path) {
        return GenerationUtils.toRelativePath((String)path, (File)VfsUtil.virtualToIoFile((VirtualFile)this.myProject.getBaseDir()), (String)BuildProperties.getProjectBaseDirProperty(), (GenerationOptions)this.myGenerationOptions);
    }

    public void runBeforeCurrentArtifact(Generator generator) {
        this.myBeforeCurrentArtifact.add(generator);
    }

    public void runBeforeBuild(Generator generator) {
        this.myBeforeBuildGenerators.add(generator);
    }

    public void runAfterBuild(Generator generator) {
        this.myAfterBuildGenerators.add(generator);
    }

    public String createNewTempFileProperty(String basePropertyName, String fileName) {
        String tempFileName = fileName;
        int i = 1;
        String tempSubdir = null;
        while (this.myTempFileNames.contains(tempFileName)) {
            tempSubdir = String.valueOf(i++);
            tempFileName = tempSubdir + "/" + fileName;
        }
        String propertyName = basePropertyName;
        i = 2;
        while (this.myProperties.contains(propertyName)) {
            propertyName = basePropertyName + i++;
        }
        this.runBeforeBuild((Generator)new Property(propertyName, BuildProperties.propertyRelativePath((String)ARTIFACTS_TEMP_DIR_PROPERTY, (String)tempFileName)));
        if (tempSubdir != null && this.myCreatedTempSubdirs.add(tempSubdir)) {
            this.runBeforeBuild((Generator)new Mkdir(BuildProperties.propertyRelativePath((String)ARTIFACTS_TEMP_DIR_PROPERTY, (String)tempSubdir)));
        }
        this.myTempFileNames.add(tempFileName);
        this.myProperties.add(propertyName);
        return propertyName;
    }

    public Generator[] getAndClearBeforeCurrentArtifact() {
        Generator[] generators = this.myBeforeCurrentArtifact.toArray(new Generator[this.myBeforeCurrentArtifact.size()]);
        this.myBeforeCurrentArtifact.clear();
        return generators;
    }

    public String getModuleOutputPath(String moduleName) {
        return BuildProperties.getOutputPathProperty((String)moduleName);
    }

    public String getModuleTestOutputPath(@NonNls String moduleName) {
        return BuildProperties.getOutputPathForTestsProperty((String)moduleName);
    }

    public List<Generator> getBeforeBuildGenerators() {
        return this.myBeforeBuildGenerators;
    }

    public List<Generator> getAfterBuildGenerators() {
        return this.myAfterBuildGenerators;
    }
}

