/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.actions.ArtifactAwareProjectSettingsService;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactsWorkspaceSettings;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import gnu.trove.TIntArrayList;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildArtifactAction
extends DumbAwareAction {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Clean artifact");

    public BuildArtifactAction() {
        super("Build Artifacts...", "Select and build artifacts configured in the project", null);
    }

    public void update(AnActionEvent e) {
        Project project2 = BuildArtifactAction.getEventProject((AnActionEvent)e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(project2 != null && !ArtifactUtil.getArtifactWithOutputPaths(project2).isEmpty());
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = BuildArtifactAction.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            return;
        }
        List<Artifact> artifacts = ArtifactUtil.getArtifactWithOutputPaths(project2);
        if (artifacts.isEmpty()) {
            return;
        }
        ArrayList<ArtifactPopupItem> items = new ArrayList<ArtifactPopupItem>();
        if (artifacts.size() > 1) {
            items.add(0, new ArtifactPopupItem(null, "All Artifacts", EmptyIcon.ICON_16));
        }
        HashSet<Artifact> selectedArtifacts = new HashSet<Artifact>(ArtifactsWorkspaceSettings.getInstance(project2).getArtifactsToBuild());
        TIntArrayList selectedIndices = new TIntArrayList();
        if (Comparing.haveEqualElements(artifacts, selectedArtifacts) && selectedArtifacts.size() > 1) {
            selectedIndices.add(0);
            selectedArtifacts.clear();
        }
        for (Artifact artifact : artifacts) {
            ArtifactPopupItem item = new ArtifactPopupItem(artifact, artifact.getName(), artifact.getArtifactType().getIcon());
            if (selectedArtifacts.contains(artifact)) {
                selectedIndices.add(items.size());
            }
            items.add(item);
        }
        ProjectSettingsService projectSettingsService = ProjectSettingsService.getInstance(project2);
        final ArtifactAwareProjectSettingsService settingsService = projectSettingsService instanceof ArtifactAwareProjectSettingsService ? (ArtifactAwareProjectSettingsService)((Object)projectSettingsService) : null;
        ChooseArtifactStep step = new ChooseArtifactStep(items, artifacts.get(0), project2, settingsService);
        step.setDefaultOptionIndices(selectedIndices.toNativeArray());
        final ListPopupImpl popup = (ListPopupImpl)JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        KeyStroke editKeyStroke = KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.getEditSource());
        if (settingsService != null && editKeyStroke != null) {
            popup.registerAction("editArtifact", editKeyStroke, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] values = popup.getSelectedValues();
                    popup.cancel();
                    settingsService.openArtifactSettings(values.length > 0 ? ((ArtifactPopupItem)values[0]).getArtifact() : null);
                }
            });
        }
        popup.showCenteredInCurrentWindow(project2);
    }

    private static void doBuild(@NotNull Project project2, @NotNull List<ArtifactPopupItem> items, boolean rebuild) {
        Set<Artifact> artifacts = BuildArtifactAction.getArtifacts(items, project2);
        CompileScope scope = ArtifactCompileScope.createArtifactsScope(project2, artifacts, rebuild);
        ArtifactsWorkspaceSettings.getInstance(project2).setArtifactsToBuild(artifacts);
        CompilerManager.getInstance((Project)project2).make(scope, null);
    }

    private static Set<Artifact> getArtifacts(List<ArtifactPopupItem> items, Project project2) {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        for (ArtifactPopupItem item : items) {
            artifacts.addAll(item.getArtifacts(project2));
        }
        return artifacts;
    }

    private static class ChooseArtifactStep
    extends MultiSelectionListPopupStep<ArtifactPopupItem> {
        private final Artifact myFirst;
        private final Project myProject;
        private ArtifactAwareProjectSettingsService mySettingsService;

        public ChooseArtifactStep(List<ArtifactPopupItem> artifacts, Artifact first, Project project2, ArtifactAwareProjectSettingsService settingsService) {
            super("Build Artifact", artifacts);
            this.myFirst = first;
            this.myProject = project2;
            this.mySettingsService = settingsService;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public Icon getIconFor(ArtifactPopupItem aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ArtifactPopupItem value) {
            return value.getText();
        }

        @Override
        public boolean hasSubstep(List<ArtifactPopupItem> selectedValues) {
            return true;
        }

        public ListSeparator getSeparatorAbove(ArtifactPopupItem value) {
            return this.myFirst.equals(value.getArtifact()) ? new ListSeparator() : null;
        }

        @Override
        public PopupStep<?> onChosen(final List<ArtifactPopupItem> selectedValues, boolean finalChoice) {
            if (finalChoice) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        BuildArtifactAction.doBuild(myProject, selectedValues, false);
                    }
                });
            }
            ArrayList<ArtifactActionItem> actions = new ArrayList<ArtifactActionItem>();
            actions.add(new BuildArtifactItem((List)selectedValues, this.myProject));
            actions.add(new RebuildArtifactItem((List)selectedValues, this.myProject));
            actions.add(new CleanArtifactItem((List)selectedValues, this.myProject));
            if (this.mySettingsService != null) {
                actions.add(new EditArtifactItem(selectedValues, this.myProject, this.mySettingsService));
            }
            return new BaseListPopupStep<ArtifactActionItem>(selectedValues.size() == 1 ? "Action" : "Action for " + selectedValues.size() + " artifacts", actions){

                @NotNull
                public String getTextFor(ArtifactActionItem value) {
                    return value.getActionName();
                }

                public PopupStep onChosen(ArtifactActionItem selectedValue, boolean finalChoice) {
                    return this.doFinalStep(selectedValue);
                }
            };
        }
    }

    private static class ArtifactPopupItem {
        @Nullable
        private final Artifact myArtifact;
        private final String myText;
        private final Icon myIcon;

        private ArtifactPopupItem(@Nullable Artifact artifact, String text, Icon icon) {
            this.myArtifact = artifact;
            this.myText = text;
            this.myIcon = icon;
        }

        @Nullable
        public Artifact getArtifact() {
            return this.myArtifact;
        }

        public String getText() {
            return this.myText;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public List<Artifact> getArtifacts(Project project2) {
            Artifact artifact = this.getArtifact();
            return artifact != null ? Collections.singletonList(artifact) : ArtifactUtil.getArtifactWithOutputPaths(project2);
        }
    }

    private static abstract class ArtifactActionItem
    implements Runnable {
        protected final List<ArtifactPopupItem> myArtifactPopupItems;
        protected final Project myProject;
        private String myActionName;

        protected ArtifactActionItem(@NotNull List<ArtifactPopupItem> item, @NotNull Project project2, @NotNull String name) {
            this.myArtifactPopupItems = item;
            this.myProject = project2;
            this.myActionName = name;
        }

        public String getActionName() {
            return this.myActionName;
        }
    }

    private static class EditArtifactItem
    extends ArtifactActionItem {
        private final ArtifactAwareProjectSettingsService mySettingsService;

        private EditArtifactItem(List<ArtifactPopupItem> item, Project project2, ArtifactAwareProjectSettingsService projectSettingsService) {
            super(item, project2, "Edit...");
            this.mySettingsService = projectSettingsService;
        }

        @Override
        public void run() {
            this.mySettingsService.openArtifactSettings(((ArtifactPopupItem)this.myArtifactPopupItems.get(0)).getArtifact());
        }
    }

    private static class RebuildArtifactItem
    extends ArtifactActionItem {
        private RebuildArtifactItem(List<ArtifactPopupItem> item, Project project2) {
            super(item, project2, "Rebuild");
        }

        @Override
        public void run() {
            BuildArtifactAction.doBuild(this.myProject, this.myArtifactPopupItems, true);
        }
    }

    private static class CleanArtifactItem
    extends ArtifactActionItem {
        private CleanArtifactItem(@NotNull List<ArtifactPopupItem> item, @NotNull Project project2) {
            super(item, project2, "Clean");
        }

        @Override
        public void run() {
            VirtualFile[] roots;
            HashSet<VirtualFile> parents = new HashSet<VirtualFile>();
            for (VirtualFile root : roots = ProjectRootManager.getInstance((Project)this.myProject).getContentSourceRoots()) {
                for (VirtualFile parent = root; parent != null && !parents.contains(parent); parent = parent.getParent()) {
                    parents.add(parent);
                }
            }
            HashMap<String, String> outputPathContainingSourceRoots = new HashMap<String, String>();
            final ArrayList<Pair> toClean = new ArrayList<Pair>();
            Set artifacts = BuildArtifactAction.getArtifacts(this.myArtifactPopupItems, this.myProject);
            for (Artifact artifact : artifacts) {
                String outputPath = artifact.getOutputFilePath();
                if (outputPath == null) continue;
                toClean.add(Pair.create((Object)new File(FileUtil.toSystemDependentName((String)outputPath)), (Object)artifact));
                VirtualFile outputFile = LocalFileSystem.getInstance().findFileByPath(outputPath);
                if (!parents.contains(outputFile)) continue;
                outputPathContainingSourceRoots.put(artifact.getName(), outputPath);
            }
            if (!outputPathContainingSourceRoots.isEmpty()) {
                String message;
                if (outputPathContainingSourceRoots.size() == 1 && outputPathContainingSourceRoots.values().size() == 1) {
                    String name = (String)ContainerUtil.getFirstItem(outputPathContainingSourceRoots.keySet());
                    String output = (String)outputPathContainingSourceRoots.get(name);
                    message = "The output directory '" + output + "' of '" + name + "' artifact contains source roots of the project. Do you want to continue and clear it?";
                } else {
                    StringBuilder info = new StringBuilder();
                    for (String name : outputPathContainingSourceRoots.keySet()) {
                        info.append(" '").append(name).append("' artifact ('").append((String)outputPathContainingSourceRoots.get(name)).append("')\n");
                    }
                    message = "The output directories of the following artifacts contains source roots:\n" + info + "Do you want to continue and clear these directories?";
                }
                int answer = Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)"Clean Artifacts", null);
                if (answer != 0) {
                    return;
                }
            }
            new Task.Backgroundable(this.myProject, "Cleaning Artifacts", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    ArrayList<File> deleted = new ArrayList<File>();
                    for (Pair pair : toClean) {
                        indicator.checkCanceled();
                        File file2 = (File)pair.getFirst();
                        if (!FileUtil.delete((File)file2)) {
                            NOTIFICATION_GROUP.createNotification("Cannot clean '" + ((Artifact)pair.getSecond()).getName() + "' artifact", "cannot delete '" + file2.getAbsolutePath() + "'", NotificationType.ERROR, null).notify(this.myProject);
                            continue;
                        }
                        deleted.add(file2);
                    }
                    LocalFileSystem.getInstance().refreshIoFiles(deleted, true, true, null);
                }
            }.queue();
        }
    }

    private static class BuildArtifactItem
    extends ArtifactActionItem {
        private BuildArtifactItem(List<ArtifactPopupItem> item, Project project2) {
            super(item, project2, "Build");
        }

        @Override
        public void run() {
            BuildArtifactAction.doBuild(this.myProject, this.myArtifactPopupItems, false);
        }
    }
}

