/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.wrongPackageStatement;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.wrongPackageStatement.AdjustPackageNameFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.util.FileTypeUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrongPackageStatementInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (file2 instanceof PsiJavaFile) {
            if (FileTypeUtils.isInServerPageFile((PsiElement)file2)) {
                return null;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file2;
            PsiDirectory directory = javaFile.getContainingDirectory();
            if (directory == null) {
                return null;
            }
            PsiPackage dirPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (dirPackage == null) {
                return null;
            }
            PsiPackageStatement packageStatement = javaFile.getPackageStatement();
            PsiClass[] classes = javaFile.getClasses();
            if (classes.length == 0 && packageStatement == null) {
                return null;
            }
            String packageName = dirPackage.getQualifiedName();
            if (!Comparing.strEqual((String)packageName, (String)"", (boolean)true) && packageStatement == null) {
                String description = JavaErrorMessages.message("missing.package.statement", packageName);
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)classes[0].getNameIdentifier(), description, (LocalQuickFix)new AdjustPackageNameFix(packageName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
            }
            if (packageStatement != null) {
                PsiJavaCodeReferenceElement packageReference = packageStatement.getPackageReference();
                PsiPackage classPackage = (PsiPackage)packageReference.resolve();
                ArrayList<LocalQuickFix> availableFixes = new ArrayList<LocalQuickFix>();
                if (classPackage == null || !Comparing.equal((String)dirPackage.getQualifiedName(), (String)packageReference.getQualifiedName(), (boolean)true)) {
                    availableFixes.add(new AdjustPackageNameFix(packageName));
                    String packName = classPackage != null ? classPackage.getQualifiedName() : packageReference.getQualifiedName();
                    this.addMoveToPackageFix(file2, packName, availableFixes);
                }
                if (!availableFixes.isEmpty()) {
                    String description = JavaErrorMessages.message("package.name.file.path.mismatch", packageReference.getQualifiedName(), dirPackage.getQualifiedName());
                    LocalQuickFix[] fixes = availableFixes.toArray(new LocalQuickFix[availableFixes.size()]);
                    ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)packageStatement.getPackageReference(), description, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    return new ProblemDescriptor[]{descriptor};
                }
            }
        }
        return null;
    }

    protected void addMoveToPackageFix(PsiFile file2, String packName, List<LocalQuickFix> availableFixes) {
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"wrong.package.statement", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "WrongPackageStatement";
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

