/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.visibility;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.visibility.VisibilityInspection;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AccessCanBeTightenedInspection
extends BaseJavaBatchLocalInspectionTool {
    private final VisibilityInspection myVisibilityInspection;

    AccessCanBeTightenedInspection(@NotNull VisibilityInspection visibilityInspection) {
        this.myVisibilityInspection = visibilityInspection;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.VISIBILITY_GROUP_NAME;
    }

    @NotNull
    public String getDisplayName() {
        return "Member access can be tightened";
    }

    @NotNull
    public String getShortName() {
        return "WeakerAccess";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new MyVisitor(holder);
    }

    private static boolean isInnerClass(@NotNull PsiClass memberClass) {
        return memberClass.getContainingClass() != null || memberClass instanceof PsiAnonymousClass;
    }

    private static boolean isInReferenceList(@Nullable PsiElement list, final @NotNull PsiMember member) {
        if (list == null) {
            return false;
        }
        final PsiManager psiManager = member.getManager();
        final boolean[] result = new boolean[1];
        list.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                if (psiManager.areElementsEquivalent(reference.resolve(), (PsiElement)member)) {
                    result[0] = true;
                    this.stopWalking();
                }
            }
        });
        return result[0];
    }

    private int suggestPackageLocal(@NotNull PsiElement member) {
        boolean suggestPackageLocal = member instanceof PsiClass && ClassUtil.isTopLevelClass((PsiClass)((PsiClass)member)) ? this.myVisibilityInspection.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES : this.myVisibilityInspection.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS;
        return suggestPackageLocal ? 2 : 4;
    }

    private static void log(String s) {
    }

    private class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final UnusedDeclarationInspectionBase myDeadCodeInspection;
        private final Set<PsiClass> childMembersAreUsedOutsideMyPackage = ContainerUtil.newConcurrentSet();

        public MyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
            InspectionProfile profile = InspectionProjectProfileManager.getInstance(holder.getProject()).getInspectionProfile();
            UnusedDeclarationInspectionBase tool = (UnusedDeclarationInspectionBase)profile.getUnwrappedTool("unused", (PsiElement)holder.getFile());
            this.myDeadCodeInspection = tool == null ? new UnusedDeclarationInspectionBase() : tool;
        }

        public void visitClass(PsiClass aClass) {
            this.checkMember((PsiMember)aClass);
        }

        public void visitMethod(PsiMethod method) {
            this.checkMember((PsiMember)method);
        }

        public void visitField(PsiField field) {
            this.checkMember((PsiMember)field);
        }

        private void checkMember(@NotNull PsiMember member) {
            if (member.hasModifierProperty("private") || member.hasModifierProperty("native")) {
                return;
            }
            if (member instanceof PsiMethod && member instanceof SyntheticElement || !member.isPhysical()) {
                return;
            }
            if (member instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)member;
                if (!method.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
                    AccessCanBeTightenedInspection.log(member.getName() + " overrides");
                    return;
                }
                if (MethodUtils.isOverridden(method)) {
                    AccessCanBeTightenedInspection.log(member.getName() + " overridden");
                    return;
                }
            }
            if (member instanceof PsiEnumConstant) {
                return;
            }
            if (member instanceof PsiClass && (member instanceof PsiAnonymousClass || member instanceof PsiTypeParameter || member instanceof PsiSyntheticClass || PsiUtil.isLocalClass((PsiClass)((PsiClass)member)))) {
                return;
            }
            PsiClass memberClass = member.getContainingClass();
            if (memberClass != null && (memberClass.isInterface() || memberClass.isEnum() || memberClass.isAnnotationType() || PsiUtil.isLocalClass((PsiClass)memberClass) && member instanceof PsiClass)) {
                return;
            }
            PsiFile memberFile = member.getContainingFile();
            Project project2 = memberFile.getProject();
            if (this.myDeadCodeInspection.isEntryPoint((PsiElement)member)) {
                AccessCanBeTightenedInspection.log(member.getName() + " is entry point");
                return;
            }
            PsiModifierList memberModifierList = member.getModifierList();
            if (memberModifierList == null) {
                return;
            }
            int currentLevel = PsiUtil.getAccessLevel((PsiModifierList)memberModifierList);
            AtomicInteger maxLevel = new AtomicInteger(1);
            AtomicBoolean foundUsage = new AtomicBoolean();
            PsiDirectory memberDirectory = memberFile.getContainingDirectory();
            PsiPackage memberPackage = memberDirectory == null ? null : JavaDirectoryService.getInstance().getPackage(memberDirectory);
            AccessCanBeTightenedInspection.log(member.getName() + ": checking effective level for " + member);
            boolean proceed = UnusedSymbolUtil.processUsages(project2, memberFile, member, (ProgressIndicator)new EmptyProgressIndicator(), null, (Processor<UsageInfo>)((Processor)info -> {
                PsiElement element = info.getElement();
                if (element == null) {
                    return true;
                }
                PsiFile psiFile2 = info.getFile();
                if (psiFile2 == null) {
                    return true;
                }
                return this.handleUsage(member, memberClass, memberFile, maxLevel, memberPackage, element, psiFile2, foundUsage);
            }));
            if (proceed && member instanceof PsiClass && LambdaUtil.isFunctionalClass((PsiClass)((PsiClass)member))) {
                FunctionalExpressionSearch.search((PsiClass)((PsiClass)member)).forEach(functionalExpression -> {
                    PsiFile psiFile2 = functionalExpression.getContainingFile();
                    return this.handleUsage(member, memberClass, memberFile, maxLevel, memberPackage, (PsiElement)functionalExpression, psiFile2, foundUsage);
                });
            }
            if (!foundUsage.get()) {
                AccessCanBeTightenedInspection.log(member.getName() + " unused; ignore");
                return;
            }
            int max = maxLevel.get();
            if (max == 1 && memberClass == null) {
                max = AccessCanBeTightenedInspection.this.suggestPackageLocal((PsiElement)member);
            }
            String maxModifier = PsiUtil.getAccessModifier((int)max);
            AccessCanBeTightenedInspection.log(member.getName() + ": effective level is '" + maxModifier + "'");
            if (max < currentLevel) {
                PsiElement toHighlight;
                if (max == 2 && member instanceof PsiClass && this.childMembersAreUsedOutsideMyPackage.contains(member)) {
                    AccessCanBeTightenedInspection.log(member.getName() + "  children used outside my package; ignore");
                    return;
                }
                PsiClass cls = memberClass;
                if (cls == null && member instanceof PsiClass) {
                    cls = (PsiClass)member;
                }
                while (cls != null) {
                    String name = cls.getQualifiedName();
                    if (name != null && ("android.content.Context".equals(name) || "android.app.Fragment".equals(name) || "android.support.v4.app.Fragment".equals(name) || "android.view.View".equals(name) || "android.content.ContentProvider".equals(name) || "android.content.BroadcastReceiver".equals(name) || "android.view.ActionProvider".equals(name) || "android.os.Parcelable".equals(name))) {
                        return;
                    }
                    cls = cls.getSuperClass();
                }
                PsiElement psiElement = toHighlight = currentLevel == 2 ? ((PsiNameIdentifierOwner)member).getNameIdentifier() : (PsiElement)ContainerUtil.find((Object[])memberModifierList.getChildren(), element -> element instanceof PsiKeyword && element.getText().equals(PsiUtil.getAccessModifier((int)currentLevel)));
                assert (toHighlight != null) : member + " ; " + ((PsiNameIdentifierOwner)member).getNameIdentifier() + "; " + memberModifierList.getText();
                this.myHolder.registerProblem(toHighlight, "Access can be " + VisibilityUtil.toPresentableText((String)maxModifier), new LocalQuickFix[]{new ChangeModifierFix(maxModifier)});
            }
        }

        private boolean handleUsage(@NotNull PsiMember member, @Nullable PsiClass memberClass, @NotNull PsiFile memberFile, @NotNull AtomicInteger maxLevel, @Nullable PsiPackage memberPackage, @NotNull PsiElement element, @NotNull PsiFile psiFile, @NotNull AtomicBoolean foundUsage) {
            foundUsage.set(true);
            if (!(psiFile instanceof PsiJavaFile)) {
                AccessCanBeTightenedInspection.log("     refd from " + psiFile.getName() + "; set to public");
                maxLevel.set(4);
                if (memberClass != null) {
                    this.childMembersAreUsedOutsideMyPackage.add(memberClass);
                }
                return false;
            }
            int level = this.getEffectiveLevel(element, psiFile, member, memberFile, memberClass, memberPackage);
            AccessCanBeTightenedInspection.log("    ref in file " + psiFile.getName() + "; level = " + PsiUtil.getAccessModifier((int)level) + "; (" + element + ")");
            maxLevel.getAndAccumulate(level, Math::max);
            if (level == 4 && memberClass != null) {
                this.childMembersAreUsedOutsideMyPackage.add(memberClass);
            }
            return level != 4;
        }

        @PsiUtil.AccessLevel
        private int getEffectiveLevel(@NotNull PsiElement element, @NotNull PsiFile file2, @NotNull PsiMember member, @NotNull PsiFile memberFile, PsiClass memberClass, PsiPackage memberPackage) {
            PsiPackage aPackage;
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            boolean isAbstractMember = member.hasModifierProperty("abstract");
            if (memberClass != null && PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)memberClass, (boolean)false) || aClass != null && PsiTreeUtil.isAncestor((PsiElement)memberClass, (PsiElement)aClass, (boolean)false)) {
                if (AccessCanBeTightenedInspection.isInReferenceList((PsiElement)aClass.getModifierList(), member) || AccessCanBeTightenedInspection.isInReferenceList((PsiElement)aClass.getImplementsList(), member) || AccessCanBeTightenedInspection.isInReferenceList((PsiElement)aClass.getExtendsList(), member)) {
                    return AccessCanBeTightenedInspection.this.suggestPackageLocal((PsiElement)member);
                }
                return !isAbstractMember && (((AccessCanBeTightenedInspection)AccessCanBeTightenedInspection.this).myVisibilityInspection.SUGGEST_PRIVATE_FOR_INNERS || !AccessCanBeTightenedInspection.isInnerClass(memberClass)) ? 1 : AccessCanBeTightenedInspection.this.suggestPackageLocal((PsiElement)member);
            }
            PsiDirectory directory = file2.getContainingDirectory();
            PsiPackage psiPackage = aPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == memberPackage || aPackage != null && memberPackage != null && Comparing.strEqual((String)aPackage.getQualifiedName(), (String)memberPackage.getQualifiedName())) {
                return AccessCanBeTightenedInspection.this.suggestPackageLocal(element);
            }
            if (aClass != null && memberClass != null && aClass.isInheritor(memberClass, true)) {
                boolean isConstructor;
                PsiElement resolved = element instanceof PsiReference ? ((PsiReference)element).resolve() : null;
                boolean bl = isConstructor = resolved instanceof PsiClass && element.getParent() instanceof PsiNewExpression || resolved instanceof PsiMethod && ((PsiMethod)resolved).isConstructor();
                if (!isConstructor) {
                    return 3;
                }
            }
            return 4;
        }
    }
}

