/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedParameters;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.HTMLJavaHTMLComposer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiReferenceProcessor;
import com.intellij.psi.search.PsiReferenceProcessorAdapter;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.Processor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedParametersInspection
extends GlobalJavaBatchInspectionTool {
    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor2) {
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.isSyntheticJSP()) {
                return null;
            }
            if (refMethod.isExternalOverride()) {
                return null;
            }
            if (!(refMethod.isStatic() || refMethod.isConstructor() || refMethod.getSuperMethods().isEmpty())) {
                return null;
            }
            if ((refMethod.isAbstract() || refMethod.getOwnerClass().isInterface()) && refMethod.getDerivedMethods().isEmpty()) {
                return null;
            }
            if (refMethod.isAppMain()) {
                return null;
            }
            ArrayList<RefParameter> unusedParameters = UnusedParametersInspection.getUnusedParameters(refMethod);
            if (unusedParameters.isEmpty()) {
                return null;
            }
            if (refMethod.isEntry()) {
                return null;
            }
            PsiModifierListOwner element = refMethod.getElement();
            if (element != null && EntryPointsManager.getInstance((Project)manager.getProject()).isEntryPoint((PsiElement)element)) {
                return null;
            }
            ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
            for (RefParameter refParameter : unusedParameters) {
                PsiParameter parameter = refParameter.getElement();
                PsiIdentifier psiIdentifier = parameter != null ? parameter.getNameIdentifier() : null;
                if (psiIdentifier == null) continue;
                result.add(manager.createProblemDescriptor((PsiElement)psiIdentifier, refMethod.isAbstract() ? InspectionsBundle.message((String)"inspection.unused.parameter.composer", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.unused.parameter.composer1", (Object[])new Object[0]), (LocalQuickFix)new AcceptSuggested(globalContext.getRefManager(), processor2, refParameter.toString()), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
            }
            return result.toArray(new CommonProblemDescriptor[result.size()]);
        }
        return null;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor2) {
        Project project2 = manager.getProject();
        for (RefElement entryPoint : globalContext.getEntryPointsManager(manager).getEntryPoints()) {
            processor2.ignoreElement((RefEntity)entryPoint);
        }
        final PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)project2);
        final AnalysisScope scope = manager.getScope();
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                RefMethod refMethod;
                PsiModifierListOwner element;
                if (refEntity instanceof RefMethod && (element = (refMethod = (RefMethod)refEntity).getElement()) instanceof PsiMethod) {
                    PsiMethod psiMethod = (PsiMethod)element;
                    if (!(refMethod.isStatic() || refMethod.isConstructor() || "private".equals(refMethod.getAccessModifier()))) {
                        ArrayList<RefParameter> unusedParameters = UnusedParametersInspection.getUnusedParameters(refMethod);
                        if (unusedParameters.isEmpty()) {
                            return;
                        }
                        PsiMethod[] derived = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)psiMethod, (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY);
                        for (final RefParameter refParameter : unusedParameters) {
                            if (refMethod.isAbstract() && derived.length == 0) {
                                refParameter.parameterReferenced(false);
                                processor2.ignoreElement((RefEntity)refParameter);
                                continue;
                            }
                            int idx = refParameter.getIndex();
                            final boolean[] found = new boolean[]{false};
                            for (int i = 0; i < derived.length && !found[0]; ++i) {
                                PsiParameter[] parameters;
                                if (scope != null && scope.contains((PsiElement)derived[i]) || (parameters = derived[i].getParameterList().getParameters()).length >= idx) continue;
                                PsiParameter psiParameter = parameters[idx];
                                ReferencesSearch.search((PsiElement)psiParameter, (SearchScope)helper.getUseScope((PsiElement)psiParameter), (boolean)false).forEach((Processor)new PsiReferenceProcessorAdapter(new PsiReferenceProcessor(){

                                    public boolean execute(PsiReference element) {
                                        refParameter.parameterReferenced(false);
                                        processor2.ignoreElement((RefEntity)refParameter);
                                        found[0] = true;
                                        return false;
                                    }
                                }));
                            }
                        }
                    }
                }
            }
        });
        return false;
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        return ((AcceptSuggested)fix).getHint();
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new AcceptSuggested(null, null, hint);
    }

    public void compose(@NotNull StringBuffer buf, @NotNull RefEntity refEntity, @NotNull HTMLComposer composer) {
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            HTMLJavaHTMLComposer javaComposer = (HTMLJavaHTMLComposer)composer.getExtension(HTMLJavaHTMLComposer.COMPOSER);
            javaComposer.appendDerivedMethods(buf, refMethod);
            javaComposer.appendSuperMethods(buf, refMethod);
        }
    }

    public static ArrayList<RefParameter> getUnusedParameters(RefMethod refMethod) {
        boolean checkDeep = !refMethod.isStatic() && !refMethod.isConstructor();
        ArrayList<RefParameter> res = new ArrayList<RefParameter>();
        RefParameter[] methodParameters = refMethod.getParameters();
        RefParameter[] result = new RefParameter[methodParameters.length];
        System.arraycopy(methodParameters, 0, result, 0, methodParameters.length);
        UnusedParametersInspection.clearUsedParameters(refMethod, result, checkDeep);
        for (RefParameter parameter : result) {
            if (parameter == null || ((RefElementImpl)parameter).isSuppressed("UnusedParameters")) continue;
            res.add(parameter);
        }
        return res;
    }

    private static void clearUsedParameters(@NotNull RefMethod refMethod, RefParameter[] params, boolean checkDeep) {
        RefParameter[] methodParms = refMethod.getParameters();
        for (int i = 0; i < methodParms.length; ++i) {
            if (!methodParms[i].isUsedForReading()) continue;
            params[i] = null;
        }
        if (checkDeep) {
            for (RefMethod refOverride : refMethod.getDerivedMethods()) {
                UnusedParametersInspection.clearUsedParameters(refOverride, params, checkDeep);
            }
        }
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.unused.parameter.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DECLARATION_REDUNDANCY;
    }

    @NotNull
    public String getShortName() {
        return "UnusedParameters";
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)EntryPointsManagerImpl.createConfigureAnnotationsButton(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private static class AcceptSuggested
    implements LocalQuickFix {
        private final RefManager myManager;
        private final String myHint;
        private final ProblemDescriptionsProcessor myProcessor;

        public AcceptSuggested(RefManager manager, ProblemDescriptionsProcessor processor2, String hint) {
            this.myManager = manager;
            this.myProcessor = processor2;
            this.myHint = hint;
        }

        public String getHint() {
            return this.myHint;
        }

        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.unused.parameter.delete.quickfix", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor.getPsiElement())) {
                return;
            }
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
            if (psiMethod != null) {
                RefElement refMethod;
                ArrayList<PsiElement> psiParameters = new ArrayList<PsiElement>();
                RefElement refElement = refMethod = this.myManager != null ? this.myManager.getReference((PsiElement)psiMethod) : null;
                if (refMethod != null) {
                    for (RefParameter refParameter : UnusedParametersInspection.getUnusedParameters((RefMethod)refMethod)) {
                        psiParameters.add((PsiElement)refParameter.getElement());
                    }
                } else {
                    RefParameter parameters;
                    for (RefParameter parameter : parameters = psiMethod.getParameterList().getParameters()) {
                        if (!Comparing.strEqual((String)parameter.getName(), (String)this.myHint)) continue;
                        psiParameters.add((PsiElement)parameter);
                        break;
                    }
                }
                PsiModificationTracker tracker = psiMethod.getManager().getModificationTracker();
                long startModificationCount = tracker.getModificationCount();
                AcceptSuggested.removeUnusedParameterViaChangeSignature(psiMethod, psiParameters);
                if (refMethod != null && startModificationCount != tracker.getModificationCount()) {
                    this.myProcessor.ignoreElement((RefEntity)refMethod);
                }
            }
        }

        private static void removeUnusedParameterViaChangeSignature(PsiMethod psiMethod, Collection<PsiElement> parametersToDelete) {
            ArrayList<ParameterInfoImpl> newParameters = new ArrayList<ParameterInfoImpl>();
            PsiParameter[] oldParameters = psiMethod.getParameterList().getParameters();
            for (int i = 0; i < oldParameters.length; ++i) {
                PsiParameter oldParameter = oldParameters[i];
                if (parametersToDelete.contains(oldParameter)) continue;
                newParameters.add(new ParameterInfoImpl(i, oldParameter.getName(), oldParameter.getType()));
            }
            ParameterInfoImpl[] parameterInfos = newParameters.toArray(new ParameterInfoImpl[newParameters.size()]);
            ChangeSignatureProcessor csp = new ChangeSignatureProcessor(psiMethod.getProject(), psiMethod, false, null, psiMethod.getName(), psiMethod.getReturnType(), parameterInfos);
            csp.run();
        }
    }
}

