/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedLibraries;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedLibrariesInspection
extends GlobalInspectionTool {
    public boolean isGraphNeeded() {
        return true;
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        return new UnusedLibraryGraphAnnotator(refManager);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor2) {
        if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            Module module2 = refModule.getModule();
            if (module2.isDisposed() || !scope.containsModule(module2)) {
                return CommonProblemDescriptor.EMPTY_ARRAY;
            }
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
            Set usedRoots = (Set)refModule.getUserData(UnusedLibraryGraphAnnotator.USED_LIBRARY_ROOTS);
            ArrayList<CommonProblemDescriptor> result = new ArrayList<CommonProblemDescriptor>();
            for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
                if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).isExported()) continue;
                if (usedRoots == null) {
                    String message = InspectionsBundle.message((String)"unused.library.problem.descriptor", (Object[])new Object[]{entry.getPresentableName()});
                    result.add(manager.createProblemDescriptor(message, new QuickFix[]{new RemoveUnusedLibrary(refModule, entry, null)}));
                    continue;
                }
                HashSet<VirtualFile> files = new HashSet<VirtualFile>(Arrays.asList(((LibraryOrderEntry)entry).getRootFiles(OrderRootType.CLASSES)));
                files.removeAll(usedRoots);
                if (files.isEmpty()) continue;
                String unusedLibraryRoots = StringUtil.join(files, (Function)new Function<VirtualFile, String>(){

                    public String fun(VirtualFile file2) {
                        return file2.getPresentableName();
                    }
                }, (String)",");
                String message = InspectionsBundle.message((String)"unused.library.roots.problem.descriptor", (Object[])new Object[]{unusedLibraryRoots, entry.getPresentableName()});
                processor2.addProblemElement((RefEntity)refModule, new CommonProblemDescriptor[]{manager.createProblemDescriptor(message, new QuickFix[]{new RemoveUnusedLibrary(refModule, entry, files)})});
            }
            return result.isEmpty() ? null : result.toArray(new CommonProblemDescriptor[result.size()]);
        }
        return null;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DECLARATION_REDUNDANCY;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"unused.library.display.name", (Object[])new Object[0]);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "UnusedLibrary";
    }

    private static class UnusedLibraryGraphAnnotator
    extends RefGraphAnnotator {
        public static final Key<Set<VirtualFile>> USED_LIBRARY_ROOTS = Key.create((String)"inspection.dependencies");
        private final ProjectFileIndex myFileIndex;
        private final RefManager myManager;

        public UnusedLibraryGraphAnnotator(RefManager manager) {
            this.myManager = manager;
            this.myFileIndex = ProjectRootManager.getInstance((Project)manager.getProject()).getFileIndex();
        }

        public void onMarkReferenced(PsiElement what, PsiElement from, boolean referencedFromClassInitializer) {
            if (what != null && from != null) {
                RefModule refModule;
                Module fromModule;
                VirtualFile libraryClassRoot;
                VirtualFile containingDir;
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)what);
                VirtualFile virtualFile2 = containingDir = virtualFile != null ? virtualFile.getParent() : null;
                if (containingDir != null && (libraryClassRoot = this.myFileIndex.getClassRootForFile(containingDir)) != null && (fromModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)from)) != null && (refModule = this.myManager.getRefModule(fromModule)) != null) {
                    HashSet<VirtualFile> modules = (HashSet<VirtualFile>)refModule.getUserData(USED_LIBRARY_ROOTS);
                    if (modules == null) {
                        modules = new HashSet<VirtualFile>();
                        refModule.putUserData(USED_LIBRARY_ROOTS, modules);
                    }
                    modules.add(libraryClassRoot);
                }
            }
        }
    }

    private static class RemoveUnusedLibrary
    implements QuickFix {
        private final RefModule myRefModule;
        private final OrderEntry myOrderEntry;
        private final Set<VirtualFile> myFiles;

        public RemoveUnusedLibrary(RefModule refModule, OrderEntry orderEntry, Set<VirtualFile> files) {
            this.myRefModule = refModule;
            this.myOrderEntry = orderEntry;
            this.myFiles = files;
        }

        @NotNull
        public String getName() {
            return this.myFiles == null ? InspectionsBundle.message((String)"detach.library.quickfix.name", (Object[])new Object[0]) : InspectionsBundle.message((String)"detach.library.roots.quickfix.name", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull CommonProblemDescriptor descriptor) {
            final Module module2 = this.myRefModule.getModule();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
                    for (OrderEntry entry : model.getOrderEntries()) {
                        if (!(entry instanceof LibraryOrderEntry) || !Comparing.strEqual((String)entry.getPresentableName(), (String)myOrderEntry.getPresentableName())) continue;
                        if (myFiles == null) {
                            model.removeOrderEntry(entry);
                            continue;
                        }
                        Library library = ((LibraryOrderEntry)entry).getLibrary();
                        if (library == null) continue;
                        Library.ModifiableModel modifiableModel = library.getModifiableModel();
                        for (VirtualFile file2 : myFiles) {
                            modifiableModel.removeRoot(file2.getUrl(), OrderRootType.CLASSES);
                        }
                        modifiableModel.commit();
                    }
                    model.commit();
                }
            });
        }
    }
}

