/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unneededThrows;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.DeleteThrowsFix;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantThrowsDeclaration
extends BaseJavaBatchLocalInspectionTool
implements CleanupLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DECLARATION_REDUNDANCY;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"redundant.throws.declaration", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "RedundantThrowsDeclaration";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        final HashSet problems = new HashSet();
        file2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                ProblemDescriptor descriptor = RedundantThrowsDeclaration.checkExceptionsNeverThrown(reference, manager, isOnTheFly);
                if (descriptor != null) {
                    problems.add(descriptor);
                }
            }
        });
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static ProblemDescriptor checkExceptionsNeverThrown(PsiJavaCodeReferenceElement referenceElement, InspectionManager inspectionManager, boolean onTheFly) {
        if (!(referenceElement.getParent() instanceof PsiReferenceList)) {
            return null;
        }
        PsiReferenceList referenceList = (PsiReferenceList)referenceElement.getParent();
        if (!(referenceList.getParent() instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)referenceList.getParent();
        if (referenceList != method.getThrowsList()) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiManager manager = referenceElement.getManager();
        PsiClassType exceptionType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createType(referenceElement);
        if (ExceptionUtil.isUncheckedExceptionOrSuperclass(exceptionType)) {
            return null;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return null;
        }
        PsiModifierList modifierList = method.getModifierList();
        if (!(modifierList.hasModifierProperty("private") || modifierList.hasModifierProperty("static") || modifierList.hasModifierProperty("final") || method.isConstructor() || containingClass instanceof PsiAnonymousClass || containingClass.hasModifierProperty("final"))) {
            return null;
        }
        Collection<PsiClassType> types = ExceptionUtil.collectUnhandledExceptions((PsiElement)body, (PsiElement)method);
        HashSet<PsiClassType> unhandled = new HashSet<PsiClassType>(types);
        if (method.isConstructor()) {
            Object fields;
            for (Object field : fields = containingClass.getFields()) {
                PsiExpression initializer;
                if (field.hasModifierProperty("static") || (initializer = field.getInitializer()) == null) continue;
                unhandled.addAll(ExceptionUtil.collectUnhandledExceptions((PsiElement)initializer, (PsiElement)field));
            }
        }
        for (PsiClassType unhandledException : unhandled) {
            if (!unhandledException.isAssignableFrom((PsiType)exceptionType) && !exceptionType.isAssignableFrom((PsiType)unhandledException)) continue;
            return null;
        }
        if (JavaHighlightUtil.isSerializationRelatedMethod(method, containingClass)) {
            return null;
        }
        String description = JavaErrorMessages.message("exception.is.never.thrown", JavaHighlightUtil.formatType((PsiType)exceptionType));
        DeleteThrowsFix quickFixes = new DeleteThrowsFix(method, exceptionType);
        return inspectionManager.createProblemDescriptor((PsiElement)referenceElement, description, (LocalQuickFix)quickFixes, ProblemHighlightType.LIKE_UNUSED_SYMBOL, onTheFly);
    }
}

