/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unneededThrows;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.BidirectionalMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantThrows
extends GlobalJavaBatchInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.unneededThrows.RedundantThrows");
    private static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.redundant.throws.display.name", (Object[])new Object[0]);
    private final BidirectionalMap<String, QuickFix> myQuickFixes = new BidirectionalMap();
    @NonNls
    private static final String SHORT_NAME = "RedundantThrows";

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor2) {
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.isSyntheticJSP()) {
                return null;
            }
            if (refMethod.hasSuperMethods()) {
                return null;
            }
            if (refMethod.isEntry()) {
                return null;
            }
            PsiClass[] unThrown = refMethod.getUnThrownExceptions();
            if (unThrown == null) {
                return null;
            }
            PsiMethod psiMethod = (PsiMethod)refMethod.getElement();
            PsiClassType[] throwsList = psiMethod.getThrowsList().getReferencedTypes();
            PsiJavaCodeReferenceElement[] throwsRefs = psiMethod.getThrowsList().getReferenceElements();
            ArrayList<ProblemDescriptor> problems = null;
            PsiManager psiManager = psiMethod.getManager();
            for (int i = 0; i < throwsList.length; ++i) {
                PsiClassType throwsType = throwsList[i];
                String throwsClassName = throwsType.getClassName();
                PsiJavaCodeReferenceElement throwsRef = throwsRefs[i];
                if (ExceptionUtil.isUncheckedException(throwsType) || RedundantThrows.declaredInRemotableMethod(psiMethod, throwsType)) continue;
                for (PsiClass s : unThrown) {
                    PsiClass throwsResolvedType = throwsType.resolve();
                    if (!psiManager.areElementsEquivalent((PsiElement)s, (PsiElement)throwsResolvedType)) continue;
                    if (problems == null) {
                        problems = new ArrayList<ProblemDescriptor>(1);
                    }
                    if (refMethod.isAbstract() || refMethod.getOwnerClass().isInterface()) {
                        problems.add(manager.createProblemDescriptor((PsiElement)throwsRef, InspectionsBundle.message((String)"inspection.redundant.throws.problem.descriptor", (Object[])new Object[]{"<code>#ref</code>"}), this.getFix(processor2, throwsClassName), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
                        continue;
                    }
                    if (!refMethod.getDerivedMethods().isEmpty()) {
                        problems.add(manager.createProblemDescriptor((PsiElement)throwsRef, InspectionsBundle.message((String)"inspection.redundant.throws.problem.descriptor1", (Object[])new Object[]{"<code>#ref</code>"}), this.getFix(processor2, throwsClassName), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
                        continue;
                    }
                    problems.add(manager.createProblemDescriptor((PsiElement)throwsRef, InspectionsBundle.message((String)"inspection.redundant.throws.problem.descriptor2", (Object[])new Object[]{"<code>#ref</code>"}), this.getFix(processor2, throwsClassName), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
                }
            }
            if (problems != null) {
                return problems.toArray(new CommonProblemDescriptor[problems.size()]);
            }
        }
        return null;
    }

    private static boolean declaredInRemotableMethod(PsiMethod psiMethod, PsiClassType throwsType) {
        if (!throwsType.equalsToText("java.rmi.RemoteException")) {
            return false;
        }
        PsiClass aClass = psiMethod.getContainingClass();
        if (aClass == null) {
            return false;
        }
        PsiClass remote = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.rmi.Remote", GlobalSearchScope.allScope((Project)aClass.getProject()));
        return remote != null && aClass.isInheritor(remote, true);
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor2) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (processor2.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(final @NotNull RefMethod refMethod) {
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, new GlobalJavaInspectionContext.DerivedMethodsProcessor(){

                                public boolean process(PsiMethod derivedMethod) {
                                    processor2.ignoreElement((RefEntity)refMethod);
                                    return true;
                                }
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DECLARATION_REDUNDANCY;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    private LocalQuickFix getFix(ProblemDescriptionsProcessor processor2, String hint) {
        Object fix = (QuickFix)this.myQuickFixes.get((Object)hint);
        if (fix == null) {
            fix = new MyQuickFix(processor2, hint);
            if (hint != null) {
                this.myQuickFixes.put((Object)hint, fix);
            }
        }
        return (LocalQuickFix)fix;
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return this.getFix(null, hint);
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        List hints = this.myQuickFixes.getKeysByValue((Object)fix);
        LOG.assertTrue(hints != null && hints.size() == 1);
        return (String)hints.get(0);
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        private final ProblemDescriptionsProcessor myProcessor;
        private final String myHint;

        public MyQuickFix(ProblemDescriptionsProcessor processor2, String hint) {
            this.myProcessor = processor2;
            this.myHint = hint;
        }

        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.redundant.throws.remove.quickfix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (this.myProcessor != null) {
                RefMethod refMethod;
                CommonProblemDescriptor[] problems;
                RefElement refElement = (RefElement)this.myProcessor.getElement((CommonProblemDescriptor)descriptor);
                if (refElement instanceof RefMethod && refElement.isValid() && (problems = this.myProcessor.getDescriptions((RefEntity)(refMethod = (RefMethod)refElement))) != null) {
                    this.removeExcessiveThrows(refMethod, null, problems);
                }
            } else {
                PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
                if (psiMethod != null) {
                    this.removeExcessiveThrows(null, (PsiModifierListOwner)psiMethod, new CommonProblemDescriptor[]{descriptor});
                }
            }
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        private void removeExcessiveThrows(@Nullable RefMethod refMethod, @Nullable PsiModifierListOwner element, CommonProblemDescriptor[] problems) {
            try {
                PsiMethod psiMethod;
                if (element == null) {
                    LOG.assertTrue(refMethod != null);
                    psiMethod = (PsiMethod)refMethod.getElement();
                } else {
                    psiMethod = (PsiMethod)element;
                }
                if (psiMethod == null) {
                    return;
                }
                Project project2 = psiMethod.getProject();
                PsiManager psiManager = PsiManager.getInstance((Project)project2);
                ArrayList<PsiJavaCodeReferenceElement> refsToDelete = new ArrayList<PsiJavaCodeReferenceElement>();
                block2: for (CommonProblemDescriptor problem : problems) {
                    PsiClassType[] classTypes;
                    PsiElement psiElement = ((ProblemDescriptor)problem).getPsiElement();
                    if (psiElement instanceof PsiJavaCodeReferenceElement) {
                        PsiJavaCodeReferenceElement classRef = (PsiJavaCodeReferenceElement)psiElement;
                        PsiClassType psiType = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createType(classRef);
                        MyQuickFix.removeException(refMethod, (PsiType)psiType, refsToDelete, psiMethod);
                        continue;
                    }
                    PsiReferenceList throwsList = psiMethod.getThrowsList();
                    for (PsiClassType classType : classTypes = throwsList.getReferencedTypes()) {
                        String text = classType.getClassName();
                        if (!Comparing.strEqual((String)this.myHint, (String)text)) continue;
                        MyQuickFix.removeException(refMethod, (PsiType)classType, refsToDelete, psiMethod);
                        continue block2;
                    }
                }
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(refsToDelete)) {
                    return;
                }
                for (PsiJavaCodeReferenceElement aRefsToDelete : refsToDelete) {
                    if (!aRefsToDelete.isValid()) continue;
                    aRefsToDelete.delete();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static void removeException(RefMethod refMethod, final PsiType exceptionType, final List<PsiJavaCodeReferenceElement> refsToDelete, final PsiMethod psiMethod) {
            PsiManager psiManager = psiMethod.getManager();
            PsiJavaCodeReferenceElement[] refs = psiMethod.getThrowsList().getReferenceElements();
            for (PsiJavaCodeReferenceElement ref : refs) {
                PsiClassType refType = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createType(ref);
                if (!exceptionType.isAssignableFrom((PsiType)refType)) continue;
                refsToDelete.add(ref);
            }
            if (refMethod != null) {
                for (RefMethod refDerived : refMethod.getDerivedMethods()) {
                    PsiModifierListOwner method = refDerived.getElement();
                    if (method == null) continue;
                    MyQuickFix.removeException(refDerived, exceptionType, refsToDelete, (PsiMethod)method);
                }
            } else {
                Query query = AllOverridingMethodsSearch.search((PsiClass)psiMethod.getContainingClass());
                query.forEach((Processor)new Processor<Pair<PsiMethod, PsiMethod>>(){

                    public boolean process(Pair<PsiMethod, PsiMethod> pair) {
                        if (pair.first == psiMethod) {
                            MyQuickFix.removeException(null, exceptionType, refsToDelete, (PsiMethod)pair.second);
                        }
                        return true;
                    }
                });
            }
        }
    }
}

