/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.uncheckedWarnings;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UncheckedWarningLocalInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "UNCHECKED_WARNING";
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"unchecked.warning", (Object[])new Object[0]);
    @NonNls
    private static final String ID = "unchecked";
    private static final Logger LOG = Logger.getInstance((String)("#" + UncheckedWarningLocalInspectionBase.class));
    public boolean IGNORE_UNCHECKED_ASSIGNMENT = false;
    public boolean IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION = false;
    public boolean IGNORE_UNCHECKED_CALL = false;
    public boolean IGNORE_UNCHECKED_CAST = false;
    public boolean IGNORE_UNCHECKED_OVERRIDING = false;

    protected static JCheckBox createSetting(String cbText, boolean option, final Pass<JCheckBox> pass) {
        final JCheckBox uncheckedCb = new JCheckBox(cbText, option);
        uncheckedCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pass.pass((Object)uncheckedCb);
            }
        });
        return uncheckedCb;
    }

    public static LocalQuickFix[] getChangeVariableTypeFixes(@NotNull PsiVariable parameter, PsiType itemType) {
        if (itemType instanceof PsiMethodReferenceType) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        LOG.assertTrue(parameter.isValid());
        if (itemType != null) {
            for (ChangeVariableTypeQuickFixProvider fixProvider : (ChangeVariableTypeQuickFixProvider[])Extensions.getExtensions((ExtensionPointName)ChangeVariableTypeQuickFixProvider.EP_NAME)) {
                for (IntentionAction action : fixProvider.getFixes(parameter, itemType)) {
                    if (!(action instanceof LocalQuickFix)) continue;
                    result.add((LocalQuickFix)action);
                }
            }
        }
        return result.toArray(new LocalQuickFix[result.size()]);
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return SHORT_NAME;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    @NonNls
    public String getID() {
        return ID;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (this.IGNORE_UNCHECKED_ASSIGNMENT || this.IGNORE_UNCHECKED_CALL || this.IGNORE_UNCHECKED_CAST || this.IGNORE_UNCHECKED_OVERRIDING || this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
            super.writeSettings(node);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)session.getFile());
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return super.buildVisitor(holder, isOnTheFly, session);
        }
        return new UncheckedWarningsVisitor(isOnTheFly, languageLevel){

            @Override
            protected void registerProblem(@NotNull String message, @Nullable PsiElement callExpression, @NotNull PsiElement psiElement, @NotNull LocalQuickFix[] quickFixes) {
                String rawExpression = UncheckedWarningLocalInspectionBase.isMethodCalledOnRawType(callExpression);
                if (rawExpression != null) {
                    String referenceName = ((PsiMethodCallExpression)callExpression).getMethodExpression().getReferenceName();
                    message = message + ". Reason: '" + rawExpression + "' has raw type, so result of " + referenceName + " is erased";
                }
                holder.registerProblem(psiElement, message, quickFixes);
            }
        };
    }

    protected LocalQuickFix[] createFixes() {
        return null;
    }

    private static String isMethodCalledOnRawType(PsiElement expression) {
        PsiClass qualifierClass;
        PsiExpression qualifierExpression;
        if (expression instanceof PsiMethodCallExpression && (qualifierExpression = ((PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression()) != null && (qualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierExpression.getType())) != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)qualifierClass, (PsiSubstitutor)((PsiMethodCallExpression)expression).resolveMethodGenerics().getSubstitutor())) {
            return qualifierExpression.getText();
        }
        return null;
    }

    private abstract class UncheckedWarningsVisitor
    extends JavaElementVisitor {
        private final boolean myOnTheFly;
        @NotNull
        private final LanguageLevel myLanguageLevel;
        private final LocalQuickFix[] myGenerifyFixes;

        public UncheckedWarningsVisitor(@NotNull boolean onTheFly, LanguageLevel level) {
            this.myOnTheFly = onTheFly;
            this.myLanguageLevel = level;
            this.myGenerifyFixes = onTheFly ? UncheckedWarningLocalInspectionBase.this.createFixes() : LocalQuickFix.EMPTY_ARRAY;
        }

        protected abstract void registerProblem(@NotNull String var1, PsiElement var2, @NotNull PsiElement var3, @NotNull LocalQuickFix[] var4);

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
                return;
            }
            JavaResolveResult result = expression.advancedResolve(false);
            if (JavaGenericsUtil.isUncheckedWarning((PsiJavaCodeReferenceElement)expression, result, this.myLanguageLevel)) {
                this.registerProblem("Unchecked generics array creation for varargs parameter", null, (PsiElement)expression, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
                return;
            }
            PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
            if (classReference != null && JavaGenericsUtil.isUncheckedWarning(classReference, expression.resolveMethodGenerics(), this.myLanguageLevel)) {
                this.registerProblem("Unchecked generics array creation for varargs parameter", (PsiElement)expression, (PsiElement)classReference, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            super.visitTypeCastExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_CAST) {
                return;
            }
            PsiTypeElement typeElement = expression.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiType castType = typeElement.getType();
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType exprType = operand.getType();
            if (exprType == null) {
                return;
            }
            if (!TypeConversionUtil.areTypesConvertible((PsiType)exprType, (PsiType)castType)) {
                return;
            }
            if (JavaGenericsUtil.isUncheckedCast(castType, exprType)) {
                String description = JavaErrorMessages.message("generics.unchecked.cast", JavaHighlightUtil.formatType(exprType), JavaHighlightUtil.formatType(castType));
                this.registerProblem(description, (PsiElement)operand, (PsiElement)expression, this.myGenerifyFixes);
            }
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
            super.visitMethodReferenceExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_CALL) {
                return;
            }
            JavaResolveResult result = expression.advancedResolve(false);
            String description = this.getUncheckedCallDescription((PsiElement)expression, result);
            if (description != null) {
                PsiElement referenceNameElement = expression.getReferenceNameElement();
                this.registerProblem(description, (PsiElement)expression, (PsiElement)(referenceNameElement != null ? referenceNameElement : expression), this.myGenerifyFixes);
            }
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            super.visitCallExpression(callExpression);
            JavaResolveResult result = callExpression.resolveMethodGenerics();
            String description = this.getUncheckedCallDescription((PsiElement)callExpression, result);
            if (description != null) {
                if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_CALL) {
                    return;
                }
                PsiCallExpression element = callExpression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)callExpression).getMethodExpression() : callExpression;
                this.registerProblem(description, null, (PsiElement)element, this.myGenerifyFixes);
            } else {
                PsiMethod method;
                if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                    return;
                }
                PsiSubstitutor substitutor = result.getSubstitutor();
                PsiExpressionList argumentList = callExpression.getArgumentList();
                if (argumentList != null && (method = (PsiMethod)result.getElement()) != null) {
                    PsiExpression[] expressions = argumentList.getExpressions();
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (parameters.length != 0) {
                        for (int i = 0; i < expressions.length; ++i) {
                            PsiParameter parameter = parameters[Math.min(i, parameters.length - 1)];
                            PsiExpression expression = expressions[i];
                            PsiType parameterType = substitutor.substitute(parameter.getType());
                            PsiType expressionType = expression.getType();
                            if (expressionType == null) continue;
                            this.checkRawToGenericsAssignment((PsiElement)expression, expression, parameterType, expressionType, true, this.myGenerifyFixes);
                        }
                    }
                }
            }
        }

        public void visitVariable(PsiVariable variable) {
            super.visitVariable(variable);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null || initializer instanceof PsiArrayInitializerExpression) {
                return;
            }
            PsiType initializerType = initializer.getType();
            this.checkRawToGenericsAssignment((PsiElement)initializer, initializer, variable.getType(), initializerType, true, this.myOnTheFly ? UncheckedWarningLocalInspectionBase.getChangeVariableTypeFixes(variable, initializerType) : LocalQuickFix.EMPTY_ARRAY);
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            super.visitForeachStatement(statement2);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiParameter parameter = statement2.getIterationParameter();
            PsiType parameterType = parameter.getType();
            PsiExpression iteratedValue = statement2.getIteratedValue();
            if (iteratedValue == null) {
                return;
            }
            PsiType itemType = JavaGenericsUtil.getCollectionItemType(iteratedValue);
            this.checkRawToGenericsAssignment((PsiElement)parameter, iteratedValue, parameterType, itemType, true, this.myOnTheFly ? UncheckedWarningLocalInspectionBase.getChangeVariableTypeFixes((PsiVariable)parameter, itemType) : LocalQuickFix.EMPTY_ARRAY);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            PsiElement element;
            super.visitAssignmentExpression(expression);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            if (!"=".equals(expression.getOperationSign().getText())) {
                return;
            }
            PsiExpression lExpr = expression.getLExpression();
            PsiExpression rExpr = expression.getRExpression();
            if (rExpr == null) {
                return;
            }
            PsiType lType = lExpr.getType();
            PsiType rType = rExpr.getType();
            if (rType == null) {
                return;
            }
            PsiVariable leftVar = null;
            if (lExpr instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)lExpr).resolve()) instanceof PsiVariable) {
                leftVar = (PsiVariable)element;
            }
            this.checkRawToGenericsAssignment((PsiElement)rExpr, rExpr, lType, rType, true, this.myOnTheFly && leftVar != null ? UncheckedWarningLocalInspectionBase.getChangeVariableTypeFixes(leftVar, rType) : LocalQuickFix.EMPTY_ARRAY);
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression arrayInitializer) {
            PsiExpression[] initializers;
            super.visitArrayInitializerExpression(arrayInitializer);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiType type = arrayInitializer.getType();
            if (!(type instanceof PsiArrayType)) {
                return;
            }
            PsiType componentType = ((PsiArrayType)type).getComponentType();
            boolean arrayTypeFixChecked = false;
            VariableArrayTypeFix fix = null;
            for (PsiExpression expression : initializers = arrayInitializer.getInitializers()) {
                PsiType itemType = expression.getType();
                if (itemType == null || !TypeConversionUtil.isAssignable((PsiType)componentType, (PsiType)itemType) || !JavaGenericsUtil.isRawToGeneric(componentType, itemType)) continue;
                String description = JavaErrorMessages.message("generics.unchecked.assignment", JavaHighlightUtil.formatType(itemType), JavaHighlightUtil.formatType(componentType));
                if (!arrayTypeFixChecked) {
                    PsiType checkResult = JavaHighlightUtil.sameType(initializers);
                    fix = checkResult != null ? new VariableArrayTypeFix(arrayInitializer, checkResult) : null;
                    arrayTypeFixChecked = true;
                }
                if (fix == null) continue;
                this.registerProblem(description, null, (PsiElement)expression, new LocalQuickFix[]{fix});
            }
        }

        private void checkRawToGenericsAssignment(@NotNull PsiElement parameter, PsiExpression expression, PsiType parameterType, PsiType itemType, boolean checkAssignability, @NotNull LocalQuickFix[] quickFixes) {
            if (parameterType == null || itemType == null) {
                return;
            }
            if (checkAssignability && !TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)itemType)) {
                return;
            }
            if (JavaGenericsUtil.isRawToGeneric(parameterType, itemType)) {
                String description = JavaErrorMessages.message("generics.unchecked.assignment", JavaHighlightUtil.formatType(itemType), JavaHighlightUtil.formatType(parameterType));
                this.registerProblem(description, (PsiElement)expression, parameter, quickFixes);
            }
        }

        public void visitMethod(PsiMethod method) {
            List superMethodSignatures;
            super.visitMethod(method);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_OVERRIDING) {
                return;
            }
            if (!(method.isConstructor() || (superMethodSignatures = method.getHierarchicalMethodSignature().getSuperSignatures()).isEmpty() || method.hasModifierProperty("static"))) {
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                for (MethodSignatureBackedByPsiMethod superSignature : superMethodSignatures) {
                    PsiMethod baseMethod = superSignature.getMethod();
                    PsiSubstitutor substitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)signature, (MethodSignature)superSignature);
                    if (substitutor == null) {
                        substitutor = superSignature.getSubstitutor();
                    }
                    if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)baseMethod, (PsiSubstitutor)superSignature.getSubstitutor())) continue;
                    PsiType baseReturnType = substitutor.substitute(baseMethod.getReturnType());
                    PsiType overriderReturnType = method.getReturnType();
                    if (baseReturnType == null || overriderReturnType == null) {
                        return;
                    }
                    if (!JavaGenericsUtil.isRawToGeneric(baseReturnType, overriderReturnType)) continue;
                    String message = JavaErrorMessages.message("unchecked.overriding.incompatible.return.type", JavaHighlightUtil.formatType(overriderReturnType), JavaHighlightUtil.formatType(baseReturnType));
                    PsiTypeElement returnTypeElement = method.getReturnTypeElement();
                    LOG.assertTrue(returnTypeElement != null);
                    this.registerProblem(message, null, (PsiElement)returnTypeElement, LocalQuickFix.EMPTY_ARRAY);
                }
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement2) {
            PsiType valueType;
            PsiExpression returnValue;
            PsiMethod method;
            PsiType returnType;
            super.visitReturnStatement(statement2);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (psiElement instanceof PsiMethod && (returnType = (method = (PsiMethod)psiElement).getReturnType()) != null && !PsiType.VOID.equals((Object)returnType) && (returnValue = statement2.getReturnValue()) != null && (valueType = returnValue.getType()) != null) {
                this.checkRawToGenericsAssignment((PsiElement)returnValue, returnValue, returnType, valueType, false, new LocalQuickFix[]{QuickFixFactory.getInstance().createMethodReturnFix(method, valueType, true)});
            }
        }

        @Nullable
        private String getUncheckedCallDescription(PsiElement place, JavaResolveResult resolveResult) {
            PsiParameter[] parameters;
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiMethod)) {
                return null;
            }
            final PsiMethod method = (PsiMethod)element;
            final PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            if (!PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)method, (PsiSubstitutor)substitutor)) {
                if (JavaVersionService.getInstance().isAtLeast(place, JavaSdkVersion.JDK_1_8)) {
                    for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)method)) {
                        PsiClassType[] extendsListTypes = parameter.getExtendsListTypes();
                        if (extendsListTypes.length <= 0) continue;
                        PsiType subst = substitutor.substitute(parameter);
                        for (PsiClassType classType : extendsListTypes) {
                            if (!JavaGenericsUtil.isRawToGeneric(substitutor.substitute((PsiType)classType), subst)) continue;
                            return JavaErrorMessages.message("generics.unchecked.call", JavaHighlightUtil.formatMethod(method));
                        }
                    }
                }
                return null;
            }
            for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
                PsiType parameterType = parameter.getType();
                if (!((Boolean)parameterType.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

                    public Boolean visitPrimitiveType(PsiPrimitiveType primitiveType) {
                        return Boolean.FALSE;
                    }

                    public Boolean visitArrayType(PsiArrayType arrayType) {
                        return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
                    }

                    public Boolean visitClassType(PsiClassType classType) {
                        PsiType[] parameters;
                        PsiClass psiClass = classType.resolve();
                        if (psiClass instanceof PsiTypeParameter) {
                            if (((PsiTypeParameter)psiClass).getOwner() == method) {
                                return Boolean.FALSE;
                            }
                            return substitutor.substitute((PsiTypeParameter)psiClass) == null ? Boolean.TRUE : Boolean.FALSE;
                        }
                        for (PsiType parameter : parameters = classType.getParameters()) {
                            if (!((Boolean)parameter.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }

                    public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                        PsiType bound = wildcardType.getBound();
                        if (bound != null) {
                            return (Boolean)bound.accept((PsiTypeVisitor)this);
                        }
                        return Boolean.TRUE;
                    }

                    public Boolean visitEllipsisType(PsiEllipsisType ellipsisType) {
                        return (Boolean)ellipsisType.getComponentType().accept((PsiTypeVisitor)this);
                    }
                })).booleanValue()) continue;
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
                PsiClassType type = elementFactory.createType(method.getContainingClass(), substitutor);
                return JavaErrorMessages.message("generics.unchecked.call.to.member.of.raw.type", JavaHighlightUtil.formatMethod(method), JavaHighlightUtil.formatType((PsiType)type));
            }
            return null;
        }
    }
}

