/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvokeQuickFixAction
extends AnAction {
    private final InspectionResultsView myView;

    public InvokeQuickFixAction(InspectionResultsView view) {
        super(InspectionsBundle.message((String)"inspection.action.apply.quickfix", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.action.apply.quickfix.description", (Object[])new Object[0]), AllIcons.Actions.CreateFromUsage);
        this.myView = view;
        this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ShowIntentionActions").getShortcutSet(), (JComponent)((Object)this.myView.getTree()));
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        InspectionToolWrapper toolWrapper = this.myView.getTree().getSelectedToolWrapper();
        InspectionRVContentProvider provider = this.myView.getProvider();
        if (toolWrapper != null && provider.isContentLoaded()) {
            presentation.setEnabled(provider.hasQuickFixes(this.myView.getTree()));
        } else {
            presentation.setEnabled(false);
        }
    }

    private static ActionGroup getFixes(final QuickFixAction[] quickFixes) {
        return new ActionGroup(){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                ArrayList<QuickFixAction> children2 = new ArrayList<QuickFixAction>();
                for (QuickFixAction fix : quickFixes) {
                    if (fix == null) continue;
                    children2.add(fix);
                }
                return children2.toArray(new AnAction[children2.size()]);
            }
        };
    }

    public void actionPerformed(AnActionEvent e) {
        InspectionToolWrapper toolWrapper = this.myView.getTree().getSelectedToolWrapper();
        assert (toolWrapper != null);
        QuickFixAction[] quickFixes = this.myView.getProvider().getQuickFixes(toolWrapper, this.myView.getTree());
        if (quickFixes == null || quickFixes.length == 0) {
            Messages.showInfoMessage((Component)this.myView, (String)"There are no applicable quickfixes", (String)"Nothing found to fix");
            return;
        }
        ActionGroup fixes = InvokeQuickFixAction.getFixes(quickFixes);
        DataContext dataContext = e.getDataContext();
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(InspectionsBundle.message((String)"inspection.tree.popup.title", (Object[])new Object[0]), fixes, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        InspectionResultsView.showPopup(e, (JBPopup)popup);
    }
}

