/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.icons.AllIcons;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IconUtil;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class InspectionNode
extends InspectionTreeNode {
    public static final Icon TOOL = LayeredIcon.create((Icon)AllIcons.Toolwindows.ToolWindowInspection, (Icon)IconUtil.getEmptyIcon((boolean)false));
    private boolean myTooBigForOnlineRefresh = false;

    public InspectionNode(@NotNull InspectionToolWrapper toolWrapper) {
        super(toolWrapper);
    }

    @Override
    public String toString() {
        return this.getToolWrapper().getDisplayName();
    }

    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        return (InspectionToolWrapper)this.getUserObject();
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return TOOL;
    }

    public boolean isTooBigForOnlineRefresh() {
        if (!this.myTooBigForOnlineRefresh) {
            this.myTooBigForOnlineRefresh = this.getProblemCount() > 1000;
        }
        return this.myTooBigForOnlineRefresh;
    }

    @Override
    public int getProblemCount() {
        int sum = 0;
        Enumeration<TreeNode> children2 = this.children();
        while (children2.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)children2.nextElement();
            if (child instanceof InspectionNode) continue;
            sum += child.getProblemCount();
        }
        return sum;
    }
}

