/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sillyAssignment;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SillyAssignmentInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.variable.assigned.to.itself.display.name", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "SillyAssignment";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                SillyAssignmentInspectionBase.this.checkSillyAssignment(expression, holder);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitElement((PsiElement)expression);
            }

            public void visitVariable(PsiVariable variable) {
                PsiExpression initializer = PsiUtil.deparenthesizeExpression((PsiExpression)variable.getInitializer());
                if (initializer instanceof PsiAssignmentExpression) {
                    PsiExpression lExpr = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiAssignmentExpression)initializer).getLExpression());
                    this.checkExpression(variable, lExpr);
                } else {
                    this.checkExpression(variable, initializer);
                }
            }

            private void checkExpression(PsiVariable variable, PsiExpression expression) {
                if (!(expression instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression refExpr = (PsiReferenceExpression)expression;
                PsiExpression qualifier = refExpr.getQualifierExpression();
                if ((qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression || variable.hasModifierProperty("static")) && refExpr.isReferenceTo((PsiElement)variable)) {
                    holder.registerProblem((PsiElement)expression, InspectionsBundle.message((String)"assignment.to.declared.variable.problem.descriptor", (Object[])new Object[]{variable.getName()}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                }
            }
        };
    }

    private void checkSillyAssignment(PsiAssignmentExpression assignment, ProblemsHolder holder) {
        PsiReferenceExpression rRef;
        if (assignment.getOperationTokenType() != JavaTokenType.EQ) {
            return;
        }
        PsiExpression lExpression = assignment.getLExpression();
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return;
        }
        if (!((lExpression = PsiUtil.deparenthesizeExpression((PsiExpression)lExpression)) instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression lRef = (PsiReferenceExpression)lExpression;
        PsiElement resolved = lRef.resolve();
        if (!(resolved instanceof PsiVariable)) {
            return;
        }
        PsiVariable variable = (PsiVariable)resolved;
        if (!((rExpression = SillyAssignmentInspectionBase.deparenthesizeRExpr(rExpression, variable)) instanceof PsiReferenceExpression)) {
            if (!(rExpression instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression rAssignmentExpression = (PsiAssignmentExpression)rExpression;
            PsiExpression assignee = SillyAssignmentInspectionBase.deparenthesizeRExpr(rAssignmentExpression.getLExpression(), variable);
            if (!(assignee instanceof PsiReferenceExpression)) {
                return;
            }
            rRef = (PsiReferenceExpression)assignee;
        } else {
            rRef = (PsiReferenceExpression)rExpression;
        }
        PsiManager manager = assignment.getManager();
        if (!SillyAssignmentInspectionBase.sameInstanceReferences((PsiJavaCodeReferenceElement)lRef, (PsiJavaCodeReferenceElement)rRef, manager)) {
            return;
        }
        holder.registerProblem((PsiElement)assignment, InspectionsBundle.message((String)"assignment.to.itself.problem.descriptor", (Object[])new Object[]{variable.getName()}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{this.createRemoveAssignmentFix()});
    }

    private static PsiExpression deparenthesizeRExpr(PsiExpression rExpression, PsiVariable variable) {
        if ((rExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)rExpression)) instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)rExpression;
            PsiExpression operand = typeCastExpression.getOperand();
            PsiTypeElement castTypeElement = typeCastExpression.getCastType();
            if (castTypeElement == null || operand == null) {
                return null;
            }
            PsiType castType = castTypeElement.getType();
            if (castType instanceof PsiPrimitiveType) {
                if (variable.getType().equalsToText("java.lang.Object")) {
                    return rExpression;
                }
                if (TypeUtils.isNarrowingConversion(operand.getType(), castType)) {
                    return null;
                }
            }
            return SillyAssignmentInspectionBase.deparenthesizeRExpr(operand, variable);
        }
        return rExpression;
    }

    protected LocalQuickFix createRemoveAssignmentFix() {
        return null;
    }

    private static boolean sameInstanceReferences(@Nullable PsiJavaCodeReferenceElement lRef, @Nullable PsiJavaCodeReferenceElement rRef, PsiManager manager) {
        boolean rThis;
        PsiElement rResolved;
        if (lRef == null && rRef == null) {
            return true;
        }
        if (lRef == null || rRef == null) {
            return false;
        }
        PsiElement lResolved = lRef.resolve();
        if (!manager.areElementsEquivalent(lResolved, rResolved = rRef.resolve())) {
            return false;
        }
        if (!(lResolved instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)lResolved;
        if (variable.hasModifierProperty("static")) {
            return true;
        }
        PsiElement lQualifier = lRef.getQualifier();
        PsiElement rQualifier = rRef.getQualifier();
        if (lQualifier instanceof PsiJavaCodeReferenceElement && rQualifier instanceof PsiJavaCodeReferenceElement) {
            return SillyAssignmentInspectionBase.sameInstanceReferences((PsiJavaCodeReferenceElement)lQualifier, (PsiJavaCodeReferenceElement)rQualifier, manager);
        }
        if (Comparing.equal((Object)lQualifier, (Object)rQualifier)) {
            return true;
        }
        boolean lThis = lQualifier == null || lQualifier instanceof PsiThisExpression || lQualifier instanceof PsiSuperExpression;
        boolean bl = rThis = rQualifier == null || rQualifier instanceof PsiThisExpression || rQualifier instanceof PsiSuperExpression;
        if (lThis && rThis) {
            PsiJavaCodeReferenceElement llQualifier = SillyAssignmentInspectionBase.getQualifier(lQualifier);
            PsiJavaCodeReferenceElement rrQualifier = SillyAssignmentInspectionBase.getQualifier(rQualifier);
            return SillyAssignmentInspectionBase.sameInstanceReferences(llQualifier, rrQualifier, manager);
        }
        return false;
    }

    private static PsiJavaCodeReferenceElement getQualifier(PsiElement qualifier) {
        if (qualifier instanceof PsiThisExpression) {
            PsiClass innerMostClass;
            PsiJavaCodeReferenceElement thisQualifier = ((PsiThisExpression)qualifier).getQualifier();
            if (thisQualifier != null && (innerMostClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)thisQualifier, PsiClass.class)) == thisQualifier.resolve()) {
                return null;
            }
            return thisQualifier;
        }
        if (qualifier != null) {
            return ((PsiSuperExpression)qualifier).getQualifier();
        }
        return null;
    }
}

