/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefEntityImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RefModuleImpl
extends RefEntityImpl
implements RefModule {
    private final Module myModule;

    RefModuleImpl(@NotNull Module module2, @NotNull RefManager manager) {
        super(module2.getName(), manager);
        this.myModule = module2;
        ((RefProjectImpl)manager.getRefProject()).add(this);
    }

    @Override
    public synchronized void add(@NotNull RefEntity child) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList();
        }
        this.myChildren.add(child);
        if (child.getOwner() == null) {
            ((RefEntityImpl)child).setOwner(this);
        }
    }

    @Override
    protected synchronized void removeChild(@NotNull RefEntity child) {
        if (this.myChildren != null) {
            this.myChildren.remove(child);
        }
    }

    @Override
    public void accept(final @NotNull RefVisitor refVisitor) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                refVisitor.visitModule((RefModule)RefModuleImpl.this);
            }
        });
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    public boolean isValid() {
        return !this.myModule.isDisposed();
    }

    public Icon getIcon(boolean expanded) {
        return PlatformIcons.CLOSED_MODULE_GROUP_ICON;
    }

    @Nullable
    static RefEntity moduleFromName(RefManager manager, String name) {
        return manager.getRefModule(ModuleManager.getInstance((Project)manager.getProject()).findModuleByName(name));
    }
}

