/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.BitUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class RefEntityImpl
implements RefEntity {
    private volatile RefEntityImpl myOwner;
    protected List<RefEntity> myChildren;
    private final String myName;
    private Map<Key, Object> myUserMap;
    protected long myFlags;
    protected final RefManagerImpl myManager;

    RefEntityImpl(@NotNull String name, @NotNull RefManager manager) {
        this.myManager = (RefManagerImpl)manager;
        this.myName = this.myManager.internName(name);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getQualifiedName() {
        return this.myName;
    }

    public synchronized List<RefEntity> getChildren() {
        return this.myChildren;
    }

    public RefEntity getOwner() {
        return this.myOwner;
    }

    protected void setOwner(@Nullable RefEntityImpl owner) {
        this.myOwner = owner;
    }

    public synchronized void add(@NotNull RefEntity child) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<RefEntity>(1);
        }
        this.myChildren.add(child);
        ((RefEntityImpl)child).setOwner(this);
    }

    protected synchronized void removeChild(@NotNull RefEntity child) {
        if (this.myChildren != null) {
            this.myChildren.remove(child);
            ((RefEntityImpl)child).setOwner(null);
        }
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        RefEntityImpl refEntityImpl = this;
        synchronized (refEntityImpl) {
            if (this.myUserMap == null) {
                return null;
            }
            return (T)this.myUserMap.get(key);
        }
    }

    public void accept(final @NotNull RefVisitor refVisitor) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                refVisitor.visitElement((RefEntity)RefEntityImpl.this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putUserData(@NotNull Key<T> key, T value) {
        RefEntityImpl refEntityImpl = this;
        synchronized (refEntityImpl) {
            if (this.myUserMap == null) {
                if (value == null) {
                    return;
                }
                this.myUserMap = new THashMap();
            }
            if (value != null) {
                this.myUserMap.put(key, value);
            } else {
                this.myUserMap.remove(key);
                if (this.myUserMap.isEmpty()) {
                    this.myUserMap = null;
                }
            }
        }
    }

    public boolean checkFlag(long mask) {
        return BitUtil.isSet((long)this.myFlags, (long)mask);
    }

    public void setFlag(boolean value, long mask) {
        this.myFlags = BitUtil.set((long)this.myFlags, (long)mask, (boolean)value);
    }

    public String getExternalName() {
        return this.myName;
    }

    @NotNull
    public RefManagerImpl getRefManager() {
        return this.myManager;
    }
}

