/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class AnnotateOverriddenMethodParameterFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.AnnotateMethodFix");
    private final String myAnnotation;
    private final String[] myAnnosToRemove;

    public AnnotateOverriddenMethodParameterFix(String fqn, String ... annosToRemove) {
        this.myAnnotation = fqn;
        this.myAnnosToRemove = annosToRemove;
    }

    @NotNull
    public String getName() {
        return InspectionsBundle.message((String)"annotate.overridden.methods.parameters", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor.getPsiElement();
        PsiParameter parameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiParameter.class, (boolean)false);
        if (parameter == null) {
            return;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiMethod.class);
        if (method == null) {
            return;
        }
        Object[] parameters = method.getParameterList().getParameters();
        int index = ArrayUtilRt.find((Object[])parameters, (Object)parameter);
        ArrayList<PsiParameter> toAnnotate = new ArrayList<PsiParameter>();
        PsiMethod[] methods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)GlobalSearchScope.allScope((Project)project2), (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY);
        for (PsiMethod psiMethod : methods) {
            PsiParameter psiParameter;
            PsiParameter[] psiParameters = psiMethod.getParameterList().getParameters();
            if (index >= psiParameters.length || AnnotationUtil.isAnnotated((PsiModifierListOwner)(psiParameter = psiParameters[index]), (String)this.myAnnotation, (boolean)false, (boolean)false) || !psiMethod.getManager().isInProject((PsiElement)psiMethod)) continue;
            toAnnotate.add(psiParameter);
        }
        FileModificationService.getInstance().preparePsiElementsForWrite(toAnnotate);
        for (PsiParameter psiParam : toAnnotate) {
            try {
                assert (psiParam != null) : toAnnotate;
                if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)psiParam, (String)this.myAnnotation)) continue;
                AddAnnotationPsiFix fix = new AddAnnotationPsiFix(this.myAnnotation, (PsiModifierListOwner)psiParam, PsiNameValuePair.EMPTY_ARRAY, this.myAnnosToRemove);
                fix.invoke(project2, psiParam.getContainingFile(), (PsiElement)psiParam, (PsiElement)psiParam);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }
}

