/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantArrayForVarargsCallInspection
extends GenericsInspectionToolBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.miscGenerics.RedundantArrayForVarargsCallInspection");
    private static final LocalQuickFix myQuickFixAction = new MyQuickFix();

    @Override
    public ProblemDescriptor[] getDescriptions(@NotNull PsiElement place, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        final ArrayList problems = new ArrayList();
        place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitCallExpression(PsiCallExpression expression) {
                super.visitCallExpression(expression);
                this.checkCall((PsiCall)expression);
            }

            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                super.visitEnumConstant(enumConstant);
                this.checkCall((PsiCall)enumConstant);
            }

            public void visitClass(PsiClass aClass) {
            }

            private void checkCall(PsiCall expression) {
                JavaResolveResult resolveResult = expression.resolveMethodGenerics();
                PsiElement element = resolveResult.getElement();
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                if (!(element instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)element;
                if (!method.isVarArgs() || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, Collections.singletonList("java.lang.invoke.MethodHandle.PolymorphicSignature"))) {
                    return;
                }
                PsiParameter[] parameters = method.getParameterList().getParameters();
                PsiExpressionList argumentList = expression.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                PsiExpression[] args = argumentList.getExpressions();
                if (parameters.length != args.length) {
                    return;
                }
                PsiExpression lastArg = args[args.length - 1];
                PsiParameter lastParameter = parameters[args.length - 1];
                PsiType lastParamType = lastParameter.getType();
                LOG.assertTrue(lastParamType instanceof PsiEllipsisType);
                if (!(lastArg instanceof PsiNewExpression)) {
                    return;
                }
                PsiType substitutedLastParamType = substitutor.substitute(((PsiEllipsisType)lastParamType).toArrayType());
                PsiType lastArgType = lastArg.getType();
                if (lastArgType == null || !lastArgType.equals(substitutedLastParamType) && !lastArgType.equals(TypeConversionUtil.erasure((PsiType)substitutedLastParamType))) {
                    return;
                }
                PsiExpression[] initializers = RedundantArrayForVarargsCallInspection.getInitializers((PsiNewExpression)lastArg);
                if (initializers == null) {
                    return;
                }
                if (!this.isSafeToFlatten(expression, method, initializers)) {
                    return;
                }
                String message = InspectionsBundle.message((String)"inspection.redundant.array.creation.for.varargs.call.descriptor", (Object[])new Object[0]);
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)lastArg, message, myQuickFixAction, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                problems.add(descriptor);
            }

            private boolean isSafeToFlatten(@NotNull PsiCall callExpression, @NotNull PsiMethod oldRefMethod, @NotNull PsiExpression[] arrayElements) {
                PsiType type;
                if (arrayElements.length == 1 && (PsiType.NULL.equals((Object)(type = arrayElements[0].getType())) || type instanceof PsiArrayType)) {
                    return false;
                }
                PsiCall copy = (PsiCall)callExpression.copy();
                PsiExpressionList copyArgumentList = copy.getArgumentList();
                LOG.assertTrue(copyArgumentList != null);
                PsiExpression[] args = copyArgumentList.getExpressions();
                try {
                    args[args.length - 1].delete();
                    if (arrayElements.length > 0) {
                        copyArgumentList.addRange((PsiElement)arrayElements[0], (PsiElement)arrayElements[arrayElements.length - 1]);
                    }
                    Project project2 = callExpression.getProject();
                    if (callExpression instanceof PsiEnumConstant) {
                        PsiEnumConstant enumConstant = (PsiEnumConstant)callExpression;
                        PsiClass containingClass = enumConstant.getContainingClass();
                        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
                        PsiClassType classType = facade.getElementFactory().createType(containingClass);
                        JavaResolveResult resolveResult = facade.getResolveHelper().resolveConstructor(classType, copyArgumentList, (PsiElement)enumConstant);
                        return resolveResult.isValidResult() && resolveResult.getElement() == oldRefMethod;
                    }
                    JavaResolveResult resolveResult = copy.resolveMethodGenerics();
                    if (!resolveResult.isValidResult() || resolveResult.getElement() != oldRefMethod) {
                        return false;
                    }
                    ExpectedTypeInfo[] expectedTypes = ExpectedTypesProvider.getExpectedTypes((PsiExpression)((PsiCallExpression)callExpression), false);
                    PsiType expressionType = ((PsiCallExpression)copy).getType();
                    for (ExpectedTypeInfo expectedType : expectedTypes) {
                        if (expectedType.getType().isAssignableFrom(expressionType)) continue;
                        return false;
                    }
                    return true;
                }
                catch (IncorrectOperationException e) {
                    return false;
                }
            }
        });
        if (problems.isEmpty()) {
            return null;
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Nullable
    private static PsiExpression[] getInitializers(PsiNewExpression newExpression) {
        PsiArrayInitializerExpression initializer = newExpression.getArrayInitializer();
        if (initializer != null) {
            return initializer.getInitializers();
        }
        PsiExpression[] dims = newExpression.getArrayDimensions();
        if (dims.length > 0) {
            PsiExpression firstDimension = dims[0];
            Object value = JavaPsiFacade.getInstance((Project)newExpression.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)firstDimension);
            if (value instanceof Integer && (Integer)value == 0) {
                return PsiExpression.EMPTY_ARRAY;
            }
        }
        return null;
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.VERBOSE_GROUP_NAME;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.redundant.array.creation.display.name", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "RedundantArrayCreation";
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        private MyQuickFix() {
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiNewExpression arrayCreation = (PsiNewExpression)descriptor.getPsiElement();
            if (arrayCreation == null || !arrayCreation.isValid()) {
                return;
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(arrayCreation.getContainingFile())) {
                return;
            }
            InlineUtil.inlineArrayCreationForVarargs(arrayCreation);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.redundant.array.creation.quickfix", (Object[])new Object[0]);
        }
    }
}

