/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspectionBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocReferenceInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @NonNls
    private static final String SHORT_NAME = "JavadocReference";

    private static ProblemDescriptor createDescriptor(@NotNull PsiElement element, String template, InspectionManager manager, boolean onTheFly) {
        return manager.createProblemDescriptor(element, template, onTheFly, null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    public void visitRefInDocTag(PsiDocTag tag, JavadocManager manager, PsiElement context, List<ProblemDescriptor> problems, InspectionManager inspectionManager, boolean onTheFly) {
        PsiDocCommentOwner commentOwner;
        PsiReference reference;
        String message;
        String tagName = tag.getName();
        PsiDocTagValue value = tag.getValueElement();
        if (value == null) {
            return;
        }
        JavadocTagInfo info = manager.getTagInfo(tagName);
        if (info != null && !info.isValidInContext(context)) {
            return;
        }
        String string = message = info == null || !info.isInline() ? null : info.checkTagValue(value);
        if (message != null) {
            problems.add(JavaDocReferenceInspectionBase.createDescriptor((PsiElement)value, message, inspectionManager, onTheFly));
        }
        if ((reference = value.getReference()) == null) {
            return;
        }
        PsiElement element = reference.resolve();
        if (element != null) {
            return;
        }
        int textOffset = value.getTextOffset();
        if (textOffset == value.getTextRange().getEndOffset()) {
            return;
        }
        PsiDocTagValue valueElement = tag.getValueElement();
        if (valueElement == null) {
            return;
        }
        CharSequence paramName = value.getContainingFile().getViewProvider().getContents().subSequence(textOffset, value.getTextRange().getEndOffset());
        String params = "<code>" + paramName + "</code>";
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (onTheFly && "param".equals(tagName) && (commentOwner = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiDocCommentOwner.class)) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)commentOwner;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiDocTag[] tags = tag.getContainingComment().getTags();
            HashSet<String> unboundParams = new HashSet<String>();
            for (PsiParameter parameter : parameters) {
                if (JavaDocLocalInspectionBase.isFound(tags, (PsiElement)parameter)) continue;
                unboundParams.add(parameter.getName());
            }
            if (!unboundParams.isEmpty()) {
                fixes.add(this.createRenameReferenceQuickFix(unboundParams));
            }
        }
        fixes.add(new RemoveTagFix(tagName, paramName));
        problems.add(inspectionManager.createProblemDescriptor((PsiElement)valueElement, reference.getRangeInElement(), JavaDocReferenceInspectionBase.cannotResolveSymbolMessage(params), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly, fixes.toArray(new LocalQuickFix[fixes.size()])));
    }

    protected LocalQuickFix createRenameReferenceQuickFix(Set<String> unboundParams) {
        return null;
    }

    private static String cannotResolveSymbolMessage(String params) {
        return InspectionsBundle.message((String)"inspection.javadoc.problem.cannot.resolve", (Object[])new Object[]{params});
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (!"package-info.java".equals(file2.getName()) || !(file2 instanceof PsiJavaFile)) {
            return null;
        }
        PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getChildOfType((PsiElement)file2, PsiDocComment.class);
        PsiJavaFile javaFile = (PsiJavaFile)file2;
        String packageName = javaFile.getPackageName();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)file2.getProject()).findPackage(packageName);
        return this.checkComment(docComment, (PsiElement)aPackage, manager, isOnTheFly);
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        return this.checkMember((PsiDocCommentOwner)psiMethod, manager, isOnTheFly);
    }

    @Nullable
    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        return this.checkMember((PsiDocCommentOwner)field, manager, isOnTheFly);
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        return this.checkMember((PsiDocCommentOwner)aClass, manager, isOnTheFly);
    }

    @Nullable
    private ProblemDescriptor[] checkMember(PsiDocCommentOwner docCommentOwner, InspectionManager manager, boolean isOnTheFly) {
        return this.checkComment(docCommentOwner.getDocComment(), (PsiElement)docCommentOwner, manager, isOnTheFly);
    }

    private ProblemDescriptor[] checkComment(PsiDocComment docComment, PsiElement context, InspectionManager manager, boolean isOnTheFly) {
        if (docComment == null) {
            return null;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        HashSet<PsiJavaCodeReferenceElement> references = new HashSet<PsiJavaCodeReferenceElement>();
        docComment.accept(this.getVisitor(references, context, problems, manager, isOnTheFly));
        for (PsiJavaCodeReferenceElement reference : references) {
            PsiElement referenceNameElement = reference.getReferenceNameElement();
            problems.add(manager.createProblemDescriptor((PsiElement)(referenceNameElement != null ? referenceNameElement : reference), JavaDocReferenceInspectionBase.cannotResolveSymbolMessage("<code>" + reference.getText() + "</code>"), !isOnTheFly ? null : this.createAddQualifierFix(reference), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly));
        }
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    protected LocalQuickFix createAddQualifierFix(PsiJavaCodeReferenceElement reference) {
        return null;
    }

    private PsiElementVisitor getVisitor(final Set<PsiJavaCodeReferenceElement> references, final PsiElement context, final List<ProblemDescriptor> problems, final InspectionManager manager, final boolean onTheFly) {
        return new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitElement((PsiElement)expression);
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                JavaResolveResult result = reference.advancedResolve(false);
                if (result.getElement() == null && !result.isPackagePrefixPackageReference()) {
                    references.add(reference);
                }
            }

            public void visitDocTag(PsiDocTag tag) {
                super.visitDocTag(tag);
                JavadocManager javadocManager = JavadocManager.SERVICE.getInstance((Project)tag.getProject());
                JavadocTagInfo info = javadocManager.getTagInfo(tag.getName());
                if (info == null || !info.isInline()) {
                    JavaDocReferenceInspectionBase.this.visitRefInDocTag(tag, javadocManager, context, problems, manager, onTheFly);
                }
            }

            public void visitInlineDocTag(PsiInlineDocTag tag) {
                super.visitInlineDocTag(tag);
                JavadocManager javadocManager = JavadocManager.SERVICE.getInstance((Project)tag.getProject());
                JavaDocReferenceInspectionBase.this.visitRefInDocTag((PsiDocTag)tag, javadocManager, context, problems, manager, onTheFly);
            }

            public void visitElement(PsiElement element) {
                PsiElement[] children2;
                for (PsiElement child : children2 = element.getChildren()) {
                    if (child instanceof PsiDocCommentOwner) continue;
                    child.accept((PsiElementVisitor)this);
                }
            }
        };
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.javadoc.ref.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.javadoc.issues", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    private static class RemoveTagFix
    implements LocalQuickFix {
        private final String myTagName;
        private final CharSequence myParamName;

        public RemoveTagFix(String tagName, CharSequence paramName) {
            this.myTagName = tagName;
            this.myParamName = paramName;
        }

        @NotNull
        public String getName() {
            return "Remove @" + this.myTagName + " " + this.myParamName;
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiDocTag myTag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiDocTag.class);
            if (myTag == null) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)myTag)) {
                return;
            }
            myTag.delete();
        }
    }
}

