/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.javaDoc.JavaDocReferenceInspectionBase;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.FQNameCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class JavaDocReferenceInspection
extends JavaDocReferenceInspectionBase {
    @Override
    protected LocalQuickFix createAddQualifierFix(PsiJavaCodeReferenceElement reference) {
        List<PsiClass> classesToImport = new ImportClassFix(reference).getClassesToImport();
        return classesToImport.isEmpty() ? null : new AddQualifierFix(classesToImport);
    }

    @Override
    protected RenameReferenceQuickFix createRenameReferenceQuickFix(Set<String> unboundParams) {
        return new RenameReferenceQuickFix(unboundParams);
    }

    private class AddQualifierFix
    implements LocalQuickFix {
        private final List<PsiClass> originalClasses;

        public AddQualifierFix(List<PsiClass> originalClasses) {
            this.originalClasses = originalClasses;
        }

        @NotNull
        public String getName() {
            return QuickFixBundle.message("add.qualifier", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return QuickFixBundle.message("add.qualifier", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            final PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiJavaCodeReferenceElement.class);
            if (element instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
                Collections.sort(this.originalClasses, new PsiProximityComparator(referenceElement.getElement()));
                JBList list = new JBList((Object[])this.originalClasses.toArray(new PsiClass[this.originalClasses.size()]));
                list.setCellRenderer(new FQNameCellRenderer());
                Runnable runnable2 = new Runnable((JList)list, project2, referenceElement){
                    final /* synthetic */ JList val$list;
                    final /* synthetic */ Project val$project;
                    final /* synthetic */ PsiJavaCodeReferenceElement val$referenceElement;
                    {
                        this.val$list = jList;
                        this.val$project = project2;
                        this.val$referenceElement = psiJavaCodeReferenceElement;
                    }

                    @Override
                    public void run() {
                        if (!element.isValid()) {
                            return;
                        }
                        final int index = this.val$list.getSelectedIndex();
                        if (index < 0) {
                            return;
                        }
                        new WriteCommandAction(this.val$project, new PsiFile[]{element.getContainingFile()}){

                            protected void run(@NotNull Result result) throws Throwable {
                                PsiClass psiClass = (PsiClass)AddQualifierFix.this.originalClasses.get(index);
                                if (psiClass.isValid()) {
                                    PsiDocumentManager.getInstance((Project)val$project).commitAllDocuments();
                                    val$referenceElement.bindToElement((PsiElement)psiClass);
                                }
                            }
                        }.execute();
                    }
                };
                AsyncResult asyncResult = DataManager.getInstance().getDataContextFromFocus();
                asyncResult.doWhenDone((Consumer)new Consumer<DataContext>((JList)list, runnable2){
                    final /* synthetic */ JList val$list;
                    final /* synthetic */ Runnable val$runnable;
                    {
                        this.val$list = jList;
                        this.val$runnable = runnable2;
                    }

                    public void consume(DataContext dataContext) {
                        new PopupChooserBuilder(this.val$list).setTitle(QuickFixBundle.message("add.qualifier.original.class.chooser.title", new Object[0])).setItemChoosenCallback(this.val$runnable).createPopup().showInBestPositionFor(dataContext);
                    }
                });
            }
        }
    }

    private static class RenameReferenceQuickFix
    implements LocalQuickFix {
        private final Set<String> myUnboundParams;

        public RenameReferenceQuickFix(Set<String> unboundParams) {
            this.myUnboundParams = unboundParams;
        }

        @NotNull
        public String getName() {
            return "Change to ...";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(final @NotNull Project project2, final @NotNull ProblemDescriptor descriptor) {
            AsyncResult asyncResult = DataManager.getInstance().getDataContextFromFocus();
            asyncResult.doWhenDone((Consumer)new Consumer<DataContext>(){

                public void consume(DataContext dataContext) {
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                    assert (editor != null);
                    TextRange textRange = ((ProblemDescriptorBase)descriptor).getTextRange();
                    editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                    String word = editor.getSelectionModel().getSelectedText();
                    if (word == null || StringUtil.isEmptyOrSpaces((String)word)) {
                        return;
                    }
                    ArrayList<LookupElementBuilder> items = new ArrayList<LookupElementBuilder>();
                    for (String variant : myUnboundParams) {
                        items.add(LookupElementBuilder.create((String)variant));
                    }
                    LookupManager.getInstance(project2).showLookup(editor, items.toArray(new LookupElement[items.size()]));
                }
            });
        }
    }
}

