/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithMapPutIfAbsentFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PsiMethodCallExpression> myPutExpressionPointer;

    public ReplaceWithMapPutIfAbsentFix(PsiMethodCallExpression putExpression) {
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)putExpression.getProject());
        this.myPutExpressionPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)putExpression);
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiElement conditionalOperator = descriptor.getPsiElement();
        if (conditionalOperator == null) {
            return;
        }
        ConditionalOperatorHelper operatorHelper = ReplaceWithMapPutIfAbsentFix.getHelper(conditionalOperator);
        PsiMethodCallExpression putExpression = (PsiMethodCallExpression)this.myPutExpressionPointer.getElement();
        if (putExpression == null) {
            return;
        }
        PsiElement putContainingBranch = null;
        for (PsiElement branch : operatorHelper.getBranches(conditionalOperator)) {
            if (branch == null || !PsiTreeUtil.isAncestor((PsiElement)branch, (PsiElement)putExpression, (boolean)false)) continue;
            putContainingBranch = branch;
            break;
        }
        if (putContainingBranch == null) {
            return;
        }
        PsiExpression[] arguments = putExpression.getArgumentList().getExpressions();
        PsiElement qualifier = putExpression.getMethodExpression().getQualifier();
        if (qualifier == null) {
            return;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiElement putContainingElement = operatorHelper.getPutContainingElement((PsiElement)putExpression);
        Couple<String> boundText = ReplaceWithMapPutIfAbsentFix.getBoundText(putContainingElement, (PsiElement)putExpression);
        PsiStatement newStatement = elementFactory.createStatementFromText((String)boundText.getFirst() + qualifier.getText() + ".putIfAbsent" + "(" + arguments[0].getText() + "," + putExpression.getArgumentList().getExpressions()[1].getText() + ")" + (String)boundText.getSecond(), conditionalOperator);
        conditionalOperator.replace((PsiElement)newStatement);
    }

    private static Couple<String> getBoundText(@NotNull PsiElement parent, @NotNull PsiElement child) {
        TextRange childRange = child.getTextRange();
        int parentStartOffset = parent.getTextRange().getStartOffset();
        String parentText = parent.getText();
        return Couple.of((Object)parentText.substring(0, childRange.getStartOffset() - parentStartOffset), (Object)parentText.substring(childRange.getEndOffset() - parentStartOffset));
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("java.8.collections.api.inspection.fix.family.name", new Object[0]);
    }

    @Nls
    @NotNull
    public String getName() {
        return QuickFixBundle.message("java.8.collections.api.inspection.fix.text", "putIfAbsent");
    }

    private static ConditionalOperatorHelper getHelper(PsiElement element) {
        return element instanceof PsiConditionalExpression ? new ConditionalExpressionHelper() : new IfStatementHelper();
    }

    private static class IfStatementHelper
    implements ConditionalOperatorHelper {
        private IfStatementHelper() {
        }

        @Override
        @NotNull
        public PsiElement[] getBranches(PsiElement element) {
            PsiIfStatement ifStatement = (PsiIfStatement)element;
            return new PsiElement[]{ifStatement.getThenBranch(), ifStatement.getElseBranch()};
        }

        @Override
        @NotNull
        public PsiElement getPutContainingElement(PsiElement putElement) {
            return PsiTreeUtil.getParentOfType((PsiElement)putElement, PsiStatement.class);
        }
    }

    private static class ConditionalExpressionHelper
    implements ConditionalOperatorHelper {
        private ConditionalExpressionHelper() {
        }

        @Override
        @NotNull
        public PsiElement[] getBranches(PsiElement element) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
            return new PsiElement[]{conditionalExpression.getThenExpression(), conditionalExpression.getElseExpression()};
        }

        @Override
        @NotNull
        public PsiElement getPutContainingElement(PsiElement putElement) {
            for (PsiElement element : this.getBranches(PsiTreeUtil.getParentOfType((PsiElement)putElement, PsiConditionalExpression.class))) {
                if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)putElement, (boolean)false)) continue;
                return element;
            }
            throw new AssertionError();
        }
    }

    static interface ConditionalOperatorHelper {
        @NotNull
        public PsiElement[] getBranches(PsiElement var1);

        @NotNull
        public PsiElement getPutContainingElement(PsiElement var1);
    }
}

