/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.java18api.ReplaceWithMapPutIfAbsentFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8CollectionsApiInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(Java8CollectionsApiInspection.class);
    public boolean myReportContainsCondition;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Report when 'containsKey' is used in condition (may change semantics)", (InspectionProfileEntry)this, "myReportContainsCondition");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitConditionalExpression(PsiConditionalExpression expression) {
                ConditionInfo conditionInfo = Java8CollectionsApiInspection.this.extractConditionInfo(expression.getCondition());
                if (conditionInfo == null) {
                    return;
                }
                PsiExpression thenExpression = expression.getThenExpression();
                PsiExpression elseExpression = expression.getElseExpression();
                if (thenExpression == null || elseExpression == null) {
                    return;
                }
                Java8CollectionsApiInspection.analyzeCorrespondenceOfPutAndGet((PsiElement)(conditionInfo.isInverted() ? thenExpression : elseExpression), (PsiElement)(conditionInfo.isInverted() ? elseExpression : thenExpression), conditionInfo.getQualifier(), conditionInfo.getContainsKey(), holder, (PsiElement)expression);
            }

            public void visitIfStatement(PsiIfStatement statement2) {
                PsiStatement maybePutStatement;
                PsiStatement branch;
                PsiStatement maybeGetBranch;
                PsiExpression condition = statement2.getCondition();
                ConditionInfo conditionInfo = Java8CollectionsApiInspection.this.extractConditionInfo(condition);
                if (conditionInfo == null) {
                    return;
                }
                PsiStatement psiStatement = maybeGetBranch = conditionInfo.isInverted() ? statement2.getElseBranch() : statement2.getThenBranch();
                if (maybeGetBranch instanceof PsiBlockStatement) {
                    PsiStatement[] getBranchStatements = ((PsiBlockStatement)maybeGetBranch).getCodeBlock().getStatements();
                    if (getBranchStatements.length > 1) {
                        return;
                    }
                    maybeGetBranch = getBranchStatements.length == 0 ? null : getBranchStatements[0];
                }
                PsiStatement psiStatement2 = branch = conditionInfo.isInverted() ? statement2.getThenBranch() : statement2.getElseBranch();
                if (branch instanceof PsiBlockStatement) {
                    PsiStatement[] statements = ((PsiBlockStatement)branch).getCodeBlock().getStatements();
                    if (statements.length == 0) {
                        return;
                    }
                    if (statements.length != 1) {
                        return;
                    }
                    maybePutStatement = statements[statements.length - 1];
                } else {
                    maybePutStatement = branch;
                }
                if (maybePutStatement != null) {
                    Java8CollectionsApiInspection.analyzeCorrespondenceOfPutAndGet((PsiElement)maybePutStatement, (PsiElement)maybeGetBranch, conditionInfo.getQualifier(), conditionInfo.getContainsKey(), holder, (PsiElement)statement2);
                }
            }
        };
    }

    @Nullable
    private ConditionInfo extractConditionInfo(PsiExpression condition) {
        ConditionInfo info = Java8CollectionsApiInspection.extractConditionInfoIfGet(condition);
        if (info != null) {
            return info;
        }
        return !this.myReportContainsCondition ? null : Java8CollectionsApiInspection.extractConditionInfoIfContains(condition);
    }

    @Nullable
    private static ConditionInfo extractConditionInfoIfGet(PsiExpression condition) {
        if (condition instanceof PsiBinaryExpression && (((PsiBinaryExpression)condition).getOperationSign().getTokenType().equals(JavaTokenType.EQEQ) || ((PsiBinaryExpression)condition).getOperationSign().getTokenType().equals(JavaTokenType.NE))) {
            List operands = ContainerUtil.list((Object[])new PsiExpression[]{((PsiBinaryExpression)condition).getLOperand(), ((PsiBinaryExpression)condition).getROperand()});
            PsiExpression getQualifier = null;
            PsiExpression keyExpression = null;
            boolean isNullFound = false;
            for (PsiExpression operand : operands) {
                if (operand == null) {
                    return null;
                }
                if (operand instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression maybeGetCall = (PsiMethodCallExpression)operand;
                    if (!Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(maybeGetCall, "get")) {
                        return null;
                    }
                    PsiExpression[] arguments = maybeGetCall.getArgumentList().getExpressions();
                    if (arguments.length != 1) {
                        return null;
                    }
                    getQualifier = maybeGetCall.getMethodExpression().getQualifierExpression();
                    keyExpression = arguments[0];
                    continue;
                }
                if (!(operand instanceof PsiLiteralExpression) || !"null".equals(operand.getText())) continue;
                isNullFound = true;
            }
            if (getQualifier == null && keyExpression == null && isNullFound) {
                return null;
            }
            return new ConditionInfo(getQualifier, keyExpression, ((PsiBinaryExpression)condition).getOperationSign().getTokenType().equals(JavaTokenType.EQEQ));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static ConditionInfo extractConditionInfoIfContains(PsiExpression condition) {
        PsiMethodCallExpression conditionMethodCall;
        boolean inverted = false;
        if (condition instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
            if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationSign().getTokenType()) || !(prefixExpression.getOperand() instanceof PsiMethodCallExpression)) return null;
            conditionMethodCall = (PsiMethodCallExpression)prefixExpression.getOperand();
            inverted = true;
        } else {
            if (!(condition instanceof PsiMethodCallExpression)) return null;
            conditionMethodCall = (PsiMethodCallExpression)condition;
        }
        if (!Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(conditionMethodCall, "containsKey")) {
            return null;
        }
        PsiExpression containsQualifier = conditionMethodCall.getMethodExpression().getQualifierExpression();
        if (containsQualifier == null) {
            return null;
        }
        PsiExpression[] expressions = conditionMethodCall.getArgumentList().getExpressions();
        if (expressions.length != 1) {
            return null;
        }
        PsiExpression containsKey = expressions[0];
        return new ConditionInfo(containsQualifier, containsKey, inverted);
    }

    private static void analyzeCorrespondenceOfPutAndGet(@NotNull PsiElement adjustedElseBranch, @Nullable PsiElement adjustedThenBranch, @Nullable PsiExpression containsQualifier, @Nullable PsiExpression containsKey, @NotNull ProblemsHolder holder, @NotNull PsiElement context) {
        Object maybePutMethodCall;
        PsiElement maybeGetMethodCall;
        if (adjustedThenBranch == null) {
            PsiExpression expression;
            maybeGetMethodCall = null;
            maybePutMethodCall = adjustedElseBranch instanceof PsiExpressionStatement ? ((expression = ((PsiExpressionStatement)adjustedElseBranch).getExpression()) instanceof PsiMethodCallExpression && Java8CollectionsApiInspection.isJavaUtilMapMethodWithName((PsiMethodCallExpression)expression, "put") ? expression : null) : null;
        } else if (adjustedElseBranch instanceof PsiStatement && adjustedThenBranch instanceof PsiStatement) {
            EquivalenceChecker.Decision decision = EquivalenceChecker.statementsAreEquivalentDecision((PsiStatement)adjustedElseBranch, (PsiStatement)adjustedThenBranch);
            maybePutMethodCall = decision.getLeftDiff();
            maybeGetMethodCall = decision.getRightDiff();
        } else {
            maybePutMethodCall = adjustedElseBranch;
            maybeGetMethodCall = adjustedThenBranch;
        }
        if (maybePutMethodCall instanceof PsiMethodCallExpression && (maybeGetMethodCall == null || maybeGetMethodCall instanceof PsiMethodCallExpression)) {
            PsiExpression getQualifier;
            PsiMethodCallExpression putMethodCall = (PsiMethodCallExpression)maybePutMethodCall;
            PsiMethodCallExpression getMethodCall = (PsiMethodCallExpression)maybeGetMethodCall;
            PsiExpression putQualifier = putMethodCall.getMethodExpression().getQualifierExpression();
            PsiExpression psiExpression = getQualifier = getMethodCall == null ? null : getMethodCall.getMethodExpression().getQualifierExpression();
            if ((getMethodCall == null || EquivalenceChecker.expressionsAreEquivalent(putQualifier, getQualifier)) && EquivalenceChecker.expressionsAreEquivalent(putQualifier, containsQualifier) && Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(putMethodCall, "put") && (getMethodCall == null || Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(getMethodCall, "get"))) {
                PsiExpression getArgument;
                if (getMethodCall != null) {
                    PsiExpression[] arguments = getMethodCall.getArgumentList().getExpressions();
                    if (arguments.length != 1) {
                        return;
                    }
                    getArgument = arguments[0];
                } else {
                    getArgument = null;
                }
                PsiExpression[] putArguments = putMethodCall.getArgumentList().getExpressions();
                if (putArguments.length != 2) {
                    return;
                }
                PsiExpression putKeyArgument = putArguments[0];
                if (EquivalenceChecker.expressionsAreEquivalent(containsKey, putKeyArgument) && (getArgument == null || EquivalenceChecker.expressionsAreEquivalent(getArgument, putKeyArgument))) {
                    holder.registerProblem(context, QuickFixBundle.message("java.8.collections.api.inspection.description", new Object[0]), new LocalQuickFix[]{new ReplaceWithMapPutIfAbsentFix(putMethodCall)});
                }
            }
        }
    }

    private static boolean isJavaUtilMapMethodWithName(@NotNull PsiMethodCallExpression methodCallExpression, @NotNull String expectedName) {
        if (!expectedName.equals(methodCallExpression.getMethodExpression().getReferenceName())) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiMethod[] superMethods = method.findDeepestSuperMethods();
        if (superMethods.length == 0) {
            superMethods = new PsiMethod[]{method};
        }
        for (PsiMethod psiMethod : superMethods) {
            PsiClass aClass = psiMethod.getContainingClass();
            if (aClass == null || !"java.util.Map".equals(aClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static class ConditionInfo {
        private final PsiExpression myQualifier;
        private final PsiExpression myContainsKey;
        private final boolean myInverted;

        private ConditionInfo(PsiExpression qualifier, PsiExpression containsKey, boolean inverted) {
            this.myQualifier = qualifier;
            this.myContainsKey = containsKey;
            this.myInverted = inverted;
        }

        public PsiExpression getQualifier() {
            return this.myQualifier;
        }

        public PsiExpression getContainsKey() {
            return this.myContainsKey;
        }

        public boolean isInverted() {
            return this.myInverted;
        }
    }
}

