/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inheritance;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;

public class ChangeSuperClassFix
implements LocalQuickFix {
    @NotNull
    private final PsiClass myNewSuperClass;
    @NotNull
    private final PsiClass myOldSuperClass;
    private final int myPercent;

    public ChangeSuperClassFix(@NotNull PsiClass newSuperClass, int percent, @NotNull PsiClass oldSuperClass) {
        this.myNewSuperClass = newSuperClass;
        this.myOldSuperClass = oldSuperClass;
        this.myPercent = percent;
    }

    @NotNull
    public PsiClass getNewSuperClass() {
        return this.myNewSuperClass;
    }

    public int getPercent() {
        return this.myPercent;
    }

    @NotNull
    public String getName() {
        return String.format("Make extends '%s' - %s%%", this.myNewSuperClass.getQualifiedName(), this.myPercent);
    }

    @NotNull
    public String getFamilyName() {
        return GroupNames.INHERITANCE_GROUP_NAME;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor problemDescriptor) {
        ChangeSuperClassFix.changeSuperClass((PsiClass)problemDescriptor.getPsiElement(), this.myOldSuperClass, this.myNewSuperClass);
    }

    private static void changeSuperClass(final @NotNull PsiClass aClass, final @NotNull PsiClass oldSuperClass, final @NotNull PsiClass newSuperClass) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)aClass)) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(aClass.getContainingFile())) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(newSuperClass.getProject(), new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
                        if (aClass instanceof PsiAnonymousClass) {
                            ((PsiAnonymousClass)aClass).getBaseClassReference().replace((PsiElement)factory.createClassReferenceElement(newSuperClass));
                        } else if (oldSuperClass.isInterface()) {
                            PsiReferenceList extendsList;
                            PsiReferenceList interfaceList = aClass.getImplementsList();
                            if (interfaceList != null) {
                                for (PsiJavaCodeReferenceElement interfaceRef : interfaceList.getReferenceElements()) {
                                    PsiElement aInterface = interfaceRef.resolve();
                                    if (aInterface == null || !aInterface.isEquivalentTo((PsiElement)oldSuperClass)) continue;
                                    interfaceRef.delete();
                                }
                            }
                            if ((extendsList = aClass.getExtendsList()) != null) {
                                PsiJavaCodeReferenceElement newClassReference = factory.createClassReferenceElement(newSuperClass);
                                if (extendsList.getReferenceElements().length == 0) {
                                    extendsList.add((PsiElement)newClassReference);
                                }
                            }
                        } else {
                            PsiReferenceList extendsList = aClass.getExtendsList();
                            if (extendsList != null && extendsList.getReferenceElements().length == 1) {
                                extendsList.getReferenceElements()[0].delete();
                                PsiElement ref = extendsList.add((PsiElement)factory.createClassReferenceElement(newSuperClass));
                                JavaCodeStyleManager.getInstance((Project)aClass.getProject()).shortenClassReferences(ref);
                            }
                        }
                    }
                });
            }
        }, "Changing inheritance", null);
    }

    public static class LowPriority
    extends ChangeSuperClassFix
    implements LowPriorityAction {
        public LowPriority(@NotNull PsiClass newSuperClass, int percent, @NotNull PsiClass oldSuperClass) {
            super(newSuperClass, percent, oldSuperClass);
        }
    }
}

