/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.Html5SchemaProvider;
import org.jetbrains.annotations.NotNull;

public class SwitchToHtml5Action
implements LocalQuickFix,
IntentionAction {
    @NotNull
    public String getName() {
        return XmlErrorMessages.message("switch.to.html5.quickfix.text", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        SwitchToHtml5Action.applyFix(project2);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        SwitchToHtml5Action.applyFix(project2);
    }

    private static void applyFix(Project project2) {
        ExternalResourceManagerEx.getInstanceEx().setDefaultHtmlDoctype(Html5SchemaProvider.getHtml5SchemaLocation(), project2);
        DaemonCodeAnalyzer.getInstance((Project)project2).restart();
    }
}

