/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.annotations.NotNull;

public class RemoveAttributeIntentionAction
implements LocalQuickFix {
    private final String myLocalName;

    public RemoveAttributeIntentionAction(String localName) {
        this.myLocalName = localName;
    }

    @NotNull
    public String getName() {
        return XmlErrorMessages.message("remove.attribute.quickfix.text", this.myLocalName);
    }

    @NotNull
    public String getFamilyName() {
        return XmlErrorMessages.message("remove.attribute.quickfix.family", new Object[0]);
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiElement e = descriptor.getPsiElement();
        final XmlAttribute myAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)e, XmlAttribute.class);
        if (myAttribute == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(myAttribute.getContainingFile())) {
            return;
        }
        new WriteCommandAction(project2, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                myAttribute.delete();
            }
        }.execute();
    }
}

