/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolsImpl
implements Tools {
    @NonNls
    static final String ENABLED_BY_DEFAULT_ATTRIBUTE = "enabled_by_default";
    @NonNls
    static final String ENABLED_ATTRIBUTE = "enabled";
    @NonNls
    static final String LEVEL_ATTRIBUTE = "level";
    private final String myShortName;
    private final ScopeToolState myDefaultState;
    private List<ScopeToolState> myTools;
    private boolean myEnabled;

    public ToolsImpl(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel level, boolean enabled, boolean enabledByDefault) {
        this.myShortName = toolWrapper.getShortName();
        this.myDefaultState = new ScopeToolState(CustomScopesProviderEx.getAllScope(), toolWrapper, enabledByDefault, level);
        this.myTools = null;
        this.myEnabled = enabled;
    }

    public ToolsImpl(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel level, boolean enabled) {
        this(toolWrapper, level, enabled, enabled);
    }

    @NotNull
    public ScopeToolState addTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        return this.insertTool(scope, toolWrapper, enabled, level, this.myTools != null ? this.myTools.size() : 0);
    }

    @NotNull
    public ScopeToolState prependTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        return this.insertTool(scope, toolWrapper, enabled, level, 0);
    }

    public ScopeToolState addTool(@NotNull String scopeName, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        return this.insertTool(new ScopeToolState(scopeName, toolWrapper, enabled, level), this.myTools != null ? this.myTools.size() : 0);
    }

    @NotNull
    private ScopeToolState insertTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level, int idx) {
        return this.insertTool(new ScopeToolState(scope, toolWrapper, enabled, level), idx);
    }

    @NotNull
    private ScopeToolState insertTool(@NotNull ScopeToolState scopeToolState, int idx) {
        if (this.myTools == null) {
            this.myTools = new ArrayList<ScopeToolState>();
            if (scopeToolState.isEnabled()) {
                this.setEnabled(true);
            }
        }
        this.myTools.add(idx, scopeToolState);
        return scopeToolState;
    }

    @NotNull
    public InspectionToolWrapper getInspectionTool(PsiElement element) {
        if (this.myTools != null) {
            PsiFile containingFile = element == null ? null : element.getContainingFile();
            Project project2 = containingFile == null ? null : containingFile.getProject();
            for (ScopeToolState state : this.myTools) {
                PackageSet packageSet;
                if (element == null) {
                    return state.getTool();
                }
                NamedScope scope = state.getScope(project2);
                if (scope == null || (packageSet = scope.getValue()) == null || containingFile == null || !packageSet.contains(containingFile, (NamedScopesHolder)DependencyValidationManager.getInstance((Project)project2))) continue;
                return state.getTool();
            }
        }
        return this.myDefaultState.getTool();
    }

    @NotNull
    public String getShortName() {
        return this.myShortName;
    }

    @NotNull
    public List<InspectionToolWrapper> getAllTools() {
        ArrayList<InspectionToolWrapper> result = new ArrayList<InspectionToolWrapper>();
        for (ScopeToolState state : this.getTools()) {
            InspectionToolWrapper toolWrapper = state.getTool();
            result.add(toolWrapper);
        }
        return result;
    }

    public void writeExternal(@NotNull Element inspectionElement) throws WriteExternalException {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                Element scopeElement = new Element("scope");
                scopeElement.setAttribute("name", state.getScopeName());
                scopeElement.setAttribute(LEVEL_ATTRIBUTE, state.getLevel().getName());
                scopeElement.setAttribute(ENABLED_ATTRIBUTE, Boolean.toString(state.isEnabled()));
                InspectionToolWrapper toolWrapper = state.getTool();
                if (toolWrapper.isInitialized()) {
                    toolWrapper.getTool().writeSettings(scopeElement);
                }
                inspectionElement.addContent(scopeElement);
            }
        }
        inspectionElement.setAttribute(ENABLED_ATTRIBUTE, Boolean.toString(this.isEnabled()));
        inspectionElement.setAttribute(LEVEL_ATTRIBUTE, this.getLevel().getName());
        inspectionElement.setAttribute(ENABLED_BY_DEFAULT_ATTRIBUTE, Boolean.toString(this.myDefaultState.isEnabled()));
        InspectionToolWrapper toolWrapper = this.myDefaultState.getTool();
        if (toolWrapper.isInitialized()) {
            toolWrapper.getTool().writeSettings(inspectionElement);
        }
    }

    void readExternal(@NotNull Element toolElement, @NotNull InspectionProfile profile, Map<String, List<String>> dependencies) throws InvalidDataException {
        HighlightDisplayLevel level;
        String levelName = toolElement.getAttributeValue(LEVEL_ATTRIBUTE);
        ProfileManager profileManager = profile.getProfileManager();
        SeverityRegistrar registrar = ((SeverityProvider)profileManager).getOwnSeverityRegistrar();
        HighlightDisplayLevel highlightDisplayLevel = level = levelName != null ? HighlightDisplayLevel.find((HighlightSeverity)registrar.getSeverity(levelName)) : null;
        if (level == null || level == HighlightDisplayLevel.DO_NOT_SHOW) {
            level = HighlightDisplayLevel.WARNING;
        }
        this.myDefaultState.setLevel(level);
        String enabled = toolElement.getAttributeValue(ENABLED_ATTRIBUTE);
        boolean isEnabled = enabled != null && Boolean.parseBoolean(enabled);
        String enabledTool = toolElement.getAttributeValue(ENABLED_BY_DEFAULT_ATTRIBUTE);
        this.myDefaultState.setEnabled(enabledTool != null ? Boolean.parseBoolean(enabledTool) : isEnabled);
        InspectionToolWrapper toolWrapper = this.myDefaultState.getTool();
        List scopeElements = toolElement.getChildren("scope");
        ArrayList<String> scopeNames = new ArrayList<String>();
        for (Object sO : scopeElements) {
            HighlightDisplayLevel scopeLevel;
            Element scopeElement = (Element)sO;
            String scopeName = scopeElement.getAttributeValue("name");
            if (scopeName == null) continue;
            NamedScopesHolder scopesHolder = profileManager.getScopesManager();
            NamedScope namedScope = null;
            if (scopesHolder != null) {
                namedScope = scopesHolder.getScope(scopeName);
            }
            String errorLevel = scopeElement.getAttributeValue(LEVEL_ATTRIBUTE);
            String enabledInScope = scopeElement.getAttributeValue(ENABLED_ATTRIBUTE);
            InspectionToolWrapper copyToolWrapper = toolWrapper.createCopy();
            if (scopeElement.getAttributes().size() > 3 || !scopeElement.getChildren().isEmpty()) {
                copyToolWrapper.getTool().readSettings(scopeElement);
            }
            HighlightDisplayLevel highlightDisplayLevel2 = scopeLevel = errorLevel != null ? HighlightDisplayLevel.find((HighlightSeverity)registrar.getSeverity(errorLevel)) : null;
            if (scopeLevel == null) {
                scopeLevel = level;
            }
            if (namedScope != null) {
                this.addTool(namedScope, copyToolWrapper, enabledInScope != null && Boolean.parseBoolean(enabledInScope), scopeLevel);
            } else {
                this.addTool(scopeName, copyToolWrapper, enabledInScope != null && Boolean.parseBoolean(enabledInScope), scopeLevel);
            }
            scopeNames.add(scopeName);
        }
        for (int i = 0; i < scopeNames.size(); ++i) {
            String scopeName = (String)scopeNames.get(i);
            List<String> order = dependencies.get(scopeName);
            if (order == null) {
                order = new ArrayList<String>();
                dependencies.put(scopeName, order);
            }
            for (int j = i + 1; j < scopeNames.size(); ++j) {
                order.add((String)scopeNames.get(j));
            }
        }
        if (toolElement.getAttributes().size() > 4 || toolElement.getChildren().size() > scopeElements.size()) {
            toolWrapper.getTool().readSettings(toolElement);
        }
        this.myEnabled = isEnabled;
    }

    @NotNull
    public InspectionToolWrapper getTool() {
        if (this.myTools == null) {
            return this.myDefaultState.getTool();
        }
        return this.myTools.iterator().next().getTool();
    }

    @NotNull
    public List<ScopeToolState> getTools() {
        if (this.myTools == null) {
            return Collections.singletonList(this.myDefaultState);
        }
        ArrayList<ScopeToolState> result = new ArrayList<ScopeToolState>(this.myTools);
        result.add(this.myDefaultState);
        return result;
    }

    @NotNull
    public ScopeToolState getDefaultState() {
        return this.myDefaultState;
    }

    public void removeScope(int scopeIdx) {
        if (this.myTools != null && scopeIdx >= 0 && this.myTools.size() > scopeIdx) {
            this.myTools.remove(scopeIdx);
            this.checkToolsIsEmpty();
        }
    }

    public void removeScope(@NotNull String scopeName) {
        if (this.myTools != null) {
            for (ScopeToolState tool : this.myTools) {
                if (!scopeName.equals(tool.getScopeName())) continue;
                this.myTools.remove(tool);
                break;
            }
            this.checkToolsIsEmpty();
        }
    }

    private void checkToolsIsEmpty() {
        if (this.myTools.isEmpty()) {
            this.myTools = null;
            this.setEnabled(this.myDefaultState.isEnabled());
        }
    }

    public void removeAllScopes() {
        this.myTools = null;
    }

    public void setScope(int idx, NamedScope namedScope) {
        if (this.myTools != null && this.myTools.size() > idx && idx >= 0) {
            ScopeToolState scopeToolState = this.myTools.get(idx);
            InspectionToolWrapper toolWrapper = scopeToolState.getTool();
            this.myTools.remove(idx);
            this.myTools.add(idx, new ScopeToolState(namedScope, toolWrapper, scopeToolState.isEnabled(), scopeToolState.getLevel()));
        }
    }

    public void moveScope(int idx, int dir) {
        if (this.myTools != null && idx >= 0 && idx < this.myTools.size() && idx + dir >= 0 && idx + dir < this.myTools.size()) {
            ScopeToolState state = this.myTools.get(idx);
            this.myTools.set(idx, this.myTools.get(idx + dir));
            this.myTools.set(idx + dir, state);
        }
    }

    public boolean isEnabled(NamedScope namedScope, Project project2) {
        if (!this.myEnabled) {
            return false;
        }
        if (namedScope != null && this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)namedScope, (Object)state.getScope(project2))) continue;
                return state.isEnabled();
            }
        }
        return this.myDefaultState.isEnabled();
    }

    public HighlightDisplayLevel getLevel(PsiElement element) {
        if (this.myTools == null || element == null) {
            return this.myDefaultState.getLevel();
        }
        Project project2 = element.getProject();
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)project2);
        for (ScopeToolState state : this.myTools) {
            NamedScope scope = state.getScope(project2);
            PackageSet set = scope != null ? scope.getValue() : null;
            if (set == null || !set.contains(element.getContainingFile(), (NamedScopesHolder)manager)) continue;
            return state.getLevel();
        }
        return this.myDefaultState.getLevel();
    }

    public HighlightDisplayLevel getLevel() {
        return this.myDefaultState.getLevel();
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean isEnabled(PsiElement element) {
        if (!this.myEnabled) {
            return false;
        }
        if (this.myTools == null || element == null) {
            return this.myDefaultState.isEnabled();
        }
        Project project2 = element.getProject();
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)project2);
        for (ScopeToolState state : this.myTools) {
            PackageSet set;
            NamedScope scope = state.getScope(project2);
            if (scope == null || (set = scope.getValue()) == null || !set.contains(element.getContainingFile(), (NamedScopesHolder)manager)) continue;
            return state.isEnabled();
        }
        return this.myDefaultState.isEnabled();
    }

    @Nullable
    public InspectionToolWrapper getEnabledTool(PsiElement element) {
        if (!this.myEnabled) {
            return null;
        }
        if (this.myTools == null || element == null) {
            return this.myDefaultState.isEnabled() ? this.myDefaultState.getTool() : null;
        }
        Project project2 = element.getProject();
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)project2);
        for (ScopeToolState state : this.myTools) {
            PackageSet set;
            NamedScope scope = state.getScope(project2);
            if (scope == null || (set = scope.getValue()) == null || !set.contains(element.getContainingFile(), (NamedScopesHolder)manager)) continue;
            return state.isEnabled() ? state.getTool() : null;
        }
        return this.myDefaultState.isEnabled() ? this.myDefaultState.getTool() : null;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void enableTool(NamedScope namedScope, Project project2) {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)state.getScope(project2), (Object)namedScope)) continue;
                state.setEnabled(true);
            }
        }
        this.setEnabled(true);
    }

    public void disableTool(NamedScope namedScope, Project project2) {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)state.getScope(project2), (Object)namedScope)) continue;
                state.setEnabled(false);
            }
        }
    }

    public void disableTool(@NotNull PsiElement element) {
        Project project2 = element.getProject();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)project2);
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                PackageSet packageSet;
                NamedScope scope = state.getScope(project2);
                if (scope == null || (packageSet = scope.getValue()) == null) continue;
                PsiFile file2 = element.getContainingFile();
                if (file2 != null) {
                    if (!packageSet.contains(file2, (NamedScopesHolder)validationManager)) continue;
                    state.setEnabled(false);
                    return;
                }
                if (!(packageSet instanceof PackageSetBase) || !((PackageSetBase)packageSet).contains(PsiUtilCore.getVirtualFile((PsiElement)element), project2, (NamedScopesHolder)validationManager)) continue;
                state.setEnabled(false);
                return;
            }
            this.myDefaultState.setEnabled(false);
        } else {
            this.myDefaultState.setEnabled(false);
            this.setEnabled(false);
        }
    }

    @NotNull
    public HighlightDisplayLevel getLevel(NamedScope scope, Project project2) {
        if (this.myTools != null && scope != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)state.getScope(project2), (Object)scope)) continue;
                return state.getLevel();
            }
        }
        return this.myDefaultState.getLevel();
    }

    public boolean equals(Object o) {
        ToolsImpl tools = (ToolsImpl)o;
        if (this.myEnabled != tools.myEnabled) {
            return false;
        }
        if (this.getTools().size() != tools.getTools().size()) {
            return false;
        }
        for (int i = 0; i < this.getTools().size(); ++i) {
            ScopeToolState toolState;
            ScopeToolState state = this.getTools().get(i);
            if (state.equalTo(toolState = tools.getTools().get(i))) continue;
            return false;
        }
        return true;
    }

    public void setLevel(@NotNull HighlightDisplayLevel level, @Nullable String scopeName, Project project2) {
        if (scopeName == null) {
            this.myDefaultState.setLevel(level);
        } else {
            if (this.myTools == null) {
                return;
            }
            ScopeToolState scopeToolState = null;
            int index = -1;
            for (int i = 0; i < this.myTools.size(); ++i) {
                ScopeToolState tool = this.myTools.get(i);
                if (!scopeName.equals(tool.getScopeName())) continue;
                scopeToolState = tool;
                this.myTools.remove(tool);
                index = i;
                break;
            }
            if (index < 0) {
                throw new IllegalStateException("Scope " + scopeName + " not found");
            }
            InspectionToolWrapper toolWrapper = scopeToolState.getTool();
            NamedScope scope = scopeToolState.getScope(project2);
            if (scope != null) {
                this.myTools.add(index, new ScopeToolState(scope, toolWrapper, scopeToolState.isEnabled(), level));
            } else {
                this.myTools.add(index, new ScopeToolState(scopeToolState.getScopeName(), toolWrapper, scopeToolState.isEnabled(), level));
            }
        }
    }

    public void setDefaultState(@NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        this.myDefaultState.setTool(toolWrapper);
        this.myDefaultState.setLevel(level);
        this.myDefaultState.setEnabled(enabled);
    }

    public void setLevel(@NotNull HighlightDisplayLevel level) {
        this.myDefaultState.setLevel(level);
    }

    @Nullable
    public List<ScopeToolState> getNonDefaultTools() {
        return this.myTools;
    }
}

