/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalQuickFixWrapper
extends QuickFixAction {
    private final QuickFix myFix;
    private String myText;

    public LocalQuickFixWrapper(@NotNull QuickFix fix, @NotNull InspectionToolWrapper toolWrapper) {
        super(fix.getName(), toolWrapper);
        this.myFix = fix;
        this.myText = this.myFix.getName();
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.getTemplatePresentation().setText(this.myText);
        e.getPresentation().setText(this.myText);
    }

    @Override
    public String getText(RefEntity where) {
        return this.myText;
    }

    public void setText(@NotNull String text) {
        this.myText = text;
    }

    @Override
    protected boolean isProblemDescriptorsAcceptable() {
        return true;
    }

    @NotNull
    public QuickFix getFix() {
        return this.myFix;
    }

    @Nullable
    protected QuickFix getWorkingQuickFix(@NotNull QuickFix[] fixes) {
        QuickFix exactResult = this.getWorkingQuickFix(fixes, true);
        return exactResult != null ? exactResult : this.getWorkingQuickFix(fixes, false);
    }

    @Nullable
    protected QuickFix getWorkingQuickFix(@NotNull QuickFix[] fixes, boolean exact) {
        for (QuickFix fix : fixes) {
            if (!LocalQuickFixWrapper.checkFix(exact, this.myFix, fix) || this.myFix instanceof IntentionWrapper && fix instanceof IntentionWrapper && !LocalQuickFixWrapper.checkFix(exact, ((IntentionWrapper)this.myFix).getAction(), ((IntentionWrapper)fix).getAction())) continue;
            return fix;
        }
        return null;
    }

    private static <T> boolean checkFix(boolean exact, T thisFix, T fix) {
        return exact ? thisFix.getClass() == fix.getClass() : thisFix.getClass().isInstance(fix);
    }

    @Override
    protected boolean applyFix(@NotNull RefEntity[] refElements) {
        return true;
    }

    @Override
    protected void applyFix(final @NotNull Project project2, final @NotNull GlobalInspectionContextImpl context, final @NotNull CommonProblemDescriptor[] descriptors, final @NotNull Set<PsiElement> ignoredElements) {
        PsiModificationTracker tracker = PsiManager.getInstance((Project)project2).getModificationTracker();
        if (this.myFix instanceof BatchQuickFix) {
            final ArrayList collectedElementsToIgnore = new ArrayList();
            Runnable refreshViews = new Runnable(){

                @Override
                public void run() {
                    DaemonCodeAnalyzer.getInstance((Project)project2).restart();
                    for (CommonProblemDescriptor descriptor : descriptors) {
                        LocalQuickFixWrapper.this.ignore(ignoredElements, descriptor, LocalQuickFixWrapper.this.getWorkingQuickFix(descriptor.getFixes()), context);
                    }
                    RefManager refManager = context.getRefManager();
                    RefElement[] refElements = new RefElement[collectedElementsToIgnore.size()];
                    int collectedElementsToIgnoreSize = collectedElementsToIgnore.size();
                    for (int i = 0; i < collectedElementsToIgnoreSize; ++i) {
                        refElements[i] = refManager.getReference((PsiElement)collectedElementsToIgnore.get(i));
                    }
                    QuickFixAction.removeElements((RefEntity[])refElements, project2, LocalQuickFixWrapper.this.myToolWrapper);
                }
            };
            ((BatchQuickFix)this.myFix).applyFix(project2, descriptors, collectedElementsToIgnore, refreshViews);
            return;
        }
        boolean restart = false;
        for (CommonProblemDescriptor descriptor : descriptors) {
            QuickFix fix;
            QuickFix[] fixes;
            if (descriptor == null || (fixes = descriptor.getFixes()) == null || (fix = this.getWorkingQuickFix(fixes)) == null) continue;
            long startCount = tracker.getModificationCount();
            fix.applyFix(project2, descriptor);
            if (startCount == tracker.getModificationCount()) continue;
            restart = true;
            this.ignore(ignoredElements, descriptor, fix, context);
        }
        if (restart) {
            DaemonCodeAnalyzer.getInstance((Project)project2).restart();
        }
    }

    private void ignore(@NotNull Collection<PsiElement> ignoredElements, @NotNull CommonProblemDescriptor descriptor, @Nullable QuickFix fix, @NotNull GlobalInspectionContextImpl context) {
        PsiElement element;
        if (fix != null) {
            InspectionToolPresentation presentation = context.getPresentation(this.myToolWrapper);
            presentation.ignoreProblem(descriptor, fix);
        }
        if (descriptor instanceof ProblemDescriptor && (element = ((ProblemDescriptor)descriptor).getPsiElement()) != null) {
            ignoredElements.add(element);
        }
    }
}

